/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.element;

import com.minelittlepony.common.client.gui.element.AbstractSlider;

public class EnumSlider<T extends Enum<T>>
extends AbstractSlider<T> {
    private final T[] values;

    public EnumSlider(int x, int y, T value) {
        super(x, y, 0.0f, ((Enum[])value.getClass().getEnumConstants()).length - 1, value);
        this.values = (Enum[])value.getClass().getEnumConstants();
        this.setFormatter(t -> t.name());
    }

    @Override
    protected float valueToFloat(T value) {
        return ((Enum)value).ordinal();
    }

    @Override
    protected T floatToValue(float value) {
        for (value = (float)Math.round(value); value < 0.0f; value += (float)this.values.length) {
        }
        return this.values[(int)value % this.values.length];
    }
}

