/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.client.gui.style;

import com.minelittlepony.common.client.gui.Tooltip;
import com.minelittlepony.common.client.gui.sprite.ISprite;
import com.minelittlepony.common.client.gui.sprite.ItemStackSprite;
import java.util.List;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class Style {
    private ISprite icon = ISprite.EMPTY;
    public int toolTipX = 0;
    public int toolTipY = 0;
    private Optional<Tooltip> tooltip = Optional.empty();
    private ITextComponent text = StringTextComponent.field_240750_d_;
    private int color = -1;

    public ISprite getIcon() {
        return this.icon;
    }

    public boolean hasIcon() {
        return this.getIcon() != ISprite.EMPTY;
    }

    public Style setColor(int color) {
        this.color = color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public Style setText(String text) {
        return this.setText((ITextComponent)new TranslationTextComponent(text));
    }

    public Style setText(ITextComponent text) {
        this.text = text;
        return this;
    }

    public ITextComponent getText() {
        return this.text;
    }

    public Style setIcon(IItemProvider iitem) {
        return this.setIcon(new ItemStackSprite().setStack(iitem));
    }

    public Style setIcon(ItemStack stack) {
        return this.setIcon(new ItemStackSprite().setStack(stack));
    }

    public Style setIcon(ISprite sprite) {
        this.icon = sprite;
        return this;
    }

    public Style setIcon(ItemStack stack, int colour) {
        return this.setIcon(new ItemStackSprite().setStack(stack).setTint(colour));
    }

    public Style setTooltip(String tooltip) {
        return this.setTooltip(Tooltip.of(tooltip));
    }

    public Style setTooltip(ITextComponent tooltip) {
        return this.setTooltip(Tooltip.of(tooltip));
    }

    public Style setTooltip(String tooltip, int x, int y) {
        return this.setTooltip(tooltip).setTooltipOffset(x, y);
    }

    public Style setTooltip(ITextComponent tooltip, int x, int y) {
        return this.setTooltip(tooltip).setTooltipOffset(x, y);
    }

    public Style setTooltip(List<ITextComponent> tooltip) {
        return this.setTooltip(Tooltip.of(tooltip));
    }

    public Style setTooltip(Tooltip tooltip) {
        this.tooltip = Optional.of(tooltip);
        return this;
    }

    public Optional<Tooltip> getTooltip() {
        return this.tooltip;
    }

    public Style setTooltipOffset(int x, int y) {
        this.toolTipX = x;
        this.toolTipY = y;
        return this;
    }
}

