/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps;

import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.config.JsonFile;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import java.nio.file.Path;
import net.minecraft.util.math.MathHelper;

public class PFConfig
extends JsonFile {
    private int volume = 70;
    private String stance = "UNKNOWN";
    private boolean multiplayer = true;
    private boolean global = true;
    private final transient PresenceFootsteps pf;

    public PFConfig(Path file, PresenceFootsteps pf) {
        super(file);
        this.pf = pf;
    }

    public boolean toggleMultiplayer() {
        this.multiplayer = !this.multiplayer;
        this.save();
        return this.multiplayer;
    }

    public boolean toggleGlobal() {
        this.global = !this.global;
        this.save();
        return this.global;
    }

    public Locomotion setLocomotion(Locomotion loco) {
        if (loco != this.getLocomotion()) {
            this.stance = loco.name();
            this.save();
            this.pf.getEngine().reload();
        }
        return loco;
    }

    public Locomotion getLocomotion() {
        return Locomotion.byName(this.stance);
    }

    public boolean getEnabledGlobal() {
        return this.global && this.getEnabled();
    }

    public boolean getEnabledMP() {
        return this.multiplayer && this.getEnabled();
    }

    public boolean getEnabled() {
        return this.getVolume() > 0;
    }

    public int getVolume() {
        return MathHelper.func_76125_a((int)this.volume, (int)0, (int)100);
    }

    public float setVolume(float volume) {
        float f = volume > 97.0f ? 100.0f : (volume = volume < 3.0f ? 0.0f : (float)((int)volume));
        if ((float)this.volume != volume) {
            boolean wasEnabled = this.getEnabled();
            this.volume = (int)volume;
            this.save();
            if (this.getEnabled() != wasEnabled) {
                this.pf.getEngine().reload();
            }
        }
        return this.getVolume();
    }
}

