/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.SoundEngine;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsPlayer;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.sound.player.StepSoundPlayer;
import eu.ha3.presencefootsteps.world.GolemLookup;
import eu.ha3.presencefootsteps.world.Index;
import eu.ha3.presencefootsteps.world.LocomotionLookup;
import eu.ha3.presencefootsteps.world.Lookup;
import eu.ha3.presencefootsteps.world.PFSolver;
import eu.ha3.presencefootsteps.world.PrimitiveLookup;
import eu.ha3.presencefootsteps.world.Solver;
import eu.ha3.presencefootsteps.world.StateLookup;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;

public class PFIsolator
implements Isolator,
SoundPlayer {
    private final SoundEngine engine;
    private final Variator variator = new Variator();
    private final Index<Entity, Locomotion> locomotionMap = new LocomotionLookup();
    private final Lookup<EntityType<?>> golemMap = new GolemLookup();
    private final Lookup<BlockState> blockMap = new StateLookup();
    private final Lookup<SoundType> primitiveMap = new PrimitiveLookup();
    private final AcousticsPlayer acoustics = new AcousticsPlayer(this);
    private final Solver solver = new PFSolver(this);

    public PFIsolator(SoundEngine engine) {
        this.engine = engine;
    }

    @Override
    public void playSound(Entity location, String soundName, float volume, float pitch, Options options) {
        this.acoustics.playSound(location, soundName, volume * this.engine.getGlobalVolume(), pitch, options);
    }

    @Override
    public Random getRNG() {
        return this.acoustics.getRNG();
    }

    @Override
    public void think() {
        this.acoustics.think();
    }

    @Override
    public AcousticLibrary getAcoustics() {
        return this.acoustics;
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public Index<Entity, Locomotion> getLocomotionMap() {
        return this.locomotionMap;
    }

    @Override
    public Lookup<EntityType<?>> getGolemMap() {
        return this.golemMap;
    }

    @Override
    public Lookup<BlockState> getBlockMap() {
        return this.blockMap;
    }

    @Override
    public Lookup<SoundType> getPrimitiveMap() {
        return this.primitiveMap;
    }

    @Override
    public StepSoundPlayer getStepPlayer() {
        return this.acoustics;
    }

    @Override
    public Variator getVariator() {
        return this.variator;
    }
}

