/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound;

import eu.ha3.presencefootsteps.PFConfig;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.mixins.IEntity;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.PFIsolator;
import eu.ha3.presencefootsteps.sound.StepSoundSource;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.generator.Locomotion;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.FlyingEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;

public class SoundEngine
implements IFutureReloadListener {
    private static final ResourceLocation blockmap = new ResourceLocation("presencefootsteps", "config/blockmap.json");
    private static final ResourceLocation golemmap = new ResourceLocation("presencefootsteps", "config/golemmap.json");
    private static final ResourceLocation locomotionmap = new ResourceLocation("presencefootsteps", "config/locomotionmap.json");
    private static final ResourceLocation primitivemap = new ResourceLocation("presencefootsteps", "config/primitivemap.json");
    private static final ResourceLocation acoustics = new ResourceLocation("presencefootsteps", "config/acoustics.json");
    private static final ResourceLocation variator = new ResourceLocation("presencefootsteps", "config/variator.json");
    private static final ResourceLocation ID = new ResourceLocation("presencefootsteps", "sounds");
    private PFIsolator isolator = new PFIsolator(this);
    private final PFConfig config;

    public SoundEngine(PFConfig config) {
        this.config = config;
    }

    public float getGlobalVolume() {
        return (float)this.config.getVolume() / 100.0f;
    }

    public Isolator getIsolator() {
        return this.isolator;
    }

    public void reload() {
        if (this.config.getEnabled()) {
            this.reloadEverything(Minecraft.func_71410_x().func_195551_G());
        } else {
            this.shutdown();
        }
    }

    public boolean isRunning(Minecraft client) {
        return this.config.getEnabled() && (client.func_71387_A() || this.config.getEnabledMP());
    }

    private List<? extends Entity> getTargets(PlayerEntity ply) {
        if (this.config.getEnabledGlobal()) {
            AxisAlignedBB box = new AxisAlignedBB(ply.func_233580_cy_()).func_186662_g(16.0);
            return ply.field_70170_p.func_175674_a((Entity)null, box, e -> e instanceof LivingEntity && !(e instanceof WaterMobEntity) && !(e instanceof FlyingEntity) && !e.func_184218_aH());
        }
        return ply.field_70170_p.func_217369_A();
    }

    public void onFrame(Minecraft client, PlayerEntity player) {
        if (!client.func_147113_T() && this.isRunning(client)) {
            this.getTargets(player).forEach(e -> {
                StepSoundGenerator generator = ((StepSoundSource)e).getStepGenerator(this);
                generator.setIsolator(this.isolator);
                if (generator.generateFootsteps((LivingEntity)e)) {
                    ((IEntity)e).setNextStepDistance(2.1474836E9f);
                }
            });
            this.isolator.think();
        }
    }

    public boolean onSoundRecieved(SoundEvent event, SoundCategory category) {
        if (category != SoundCategory.PLAYERS || !this.isRunning(Minecraft.func_71410_x())) {
            return false;
        }
        if (event == SoundEvents.field_187808_ef || event == SoundEvents.field_187806_ee || event == SoundEvents.field_187736_dY || event == SoundEvents.field_187804_ed) {
            return true;
        }
        String[] name = event.func_187503_a().func_110623_a().split("\\.");
        return name.length > 0 && "block".contentEquals(name[0]) && "step".contentEquals(name[name.length - 1]);
    }

    public Locomotion getLocomotion(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            return Locomotion.forPlayer((PlayerEntity)entity, this.config.getLocomotion());
        }
        return this.isolator.getLocomotionMap().lookup((Entity)entity);
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage sync, IResourceManager sender, IProfiler serverProfiler, IProfiler clientProfiler, Executor serverExecutor, Executor clientExecutor) {
        sync.getClass();
        return sync.func_216872_a(null).thenRunAsync(() -> {
            clientProfiler.func_219894_a();
            clientProfiler.func_76320_a("Reloading PF Sounds");
            this.reloadEverything(sender);
            clientProfiler.func_76319_b();
            clientProfiler.func_219897_b();
        }, clientExecutor);
    }

    public void reloadEverything(IResourceManager manager) {
        this.isolator = new PFIsolator(this);
        this.collectResources(blockmap, manager, this.isolator.getBlockMap()::load);
        this.collectResources(golemmap, manager, this.isolator.getGolemMap()::load);
        this.collectResources(primitivemap, manager, this.isolator.getPrimitiveMap()::load);
        this.collectResources(locomotionmap, manager, this.isolator.getLocomotionMap()::load);
        this.collectResources(acoustics, manager, new AcousticsJsonParser(this.isolator.getAcoustics())::parse);
        this.collectResources(variator, manager, this.isolator.getVariator()::load);
    }

    private void collectResources(ResourceLocation id, IResourceManager manager, Consumer<Reader> consumer) {
        try {
            manager.func_199004_b(id).forEach(res -> {
                try (InputStreamReader stream = new InputStreamReader(res.func_199027_b());){
                    consumer.accept(stream);
                }
                catch (Exception e) {
                    PresenceFootsteps.logger.error("Error encountered loading resource " + res.func_199029_a() + " from pack" + res.func_199026_d(), (Throwable)e);
                }
            });
        }
        catch (IOException e) {
            PresenceFootsteps.logger.error("Error encountered opening resources for " + id, (Throwable)e);
        }
    }

    public void shutdown() {
        this.isolator = new PFIsolator(this);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            ((IEntity)player).setNextStepDistance(0.0f);
        }
    }
}

