/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonObject;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.util.Range;
import net.minecraft.entity.Entity;

class VaryingAcoustic
implements Acoustic {
    private final String soundName;
    private final Range volume = new Range(1.0f);
    private final Range pitch = new Range(1.0f);

    public VaryingAcoustic(JsonObject json, AcousticsJsonParser context) {
        this(json.get("name").getAsString(), context);
        this.volume.read("vol", json, context);
        this.pitch.read("pitch", json, context);
    }

    public VaryingAcoustic(String name, AcousticsJsonParser context) {
        this.volume.copy(context.getVolumeRange());
        this.pitch.copy(context.getPitchRange());
        this.soundName = context.getSoundName(name);
    }

    protected Options getOptions() {
        return Options.EMPTY;
    }

    @Override
    public void playSound(SoundPlayer player, Entity location, State event, Options inputOptions) {
        if (this.soundName.isEmpty()) {
            return;
        }
        float volume = this.volume.random(player.getRNG());
        float pitch = this.pitch.random(player.getRNG());
        if (inputOptions.containsKey("gliding_volume")) {
            volume = this.volume.on(inputOptions.get("gliding_volume"));
        }
        if (inputOptions.containsKey("gliding_pitch")) {
            pitch = this.pitch.on(inputOptions.get("gliding_pitch"));
        }
        player.playSound(location, this.soundName, volume, pitch, this.getOptions());
    }
}

