/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.acoustics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.Acoustic;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticsJsonParser;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;

class WeightedAcoustic
implements Acoustic {
    protected final List<Acoustic> theAcoustics;
    protected final float[] probabilityThresholds;

    public WeightedAcoustic(List<Acoustic> acoustics, List<Integer> weights) {
        int i;
        this.theAcoustics = new ArrayList<Acoustic>(acoustics);
        this.probabilityThresholds = new float[acoustics.size() - 1];
        float total = 0.0f;
        for (i = 0; i < weights.size(); ++i) {
            if (weights.get(i) < 0) {
                throw new IllegalArgumentException("A probability weight can't be negative");
            }
            total += (float)weights.get(i).intValue();
        }
        for (i = 0; i < weights.size() - 1; ++i) {
            this.probabilityThresholds[i] = (float)weights.get(i).intValue() / total;
        }
    }

    @Override
    public void playSound(SoundPlayer player, Entity location, State event, Options inputOptions) {
        int marker;
        float rand = player.getRNG().nextFloat();
        for (marker = 0; marker < this.probabilityThresholds.length && this.probabilityThresholds[marker] < rand; ++marker) {
        }
        this.theAcoustics.get(marker).playSound(player, location, event, inputOptions);
    }

    public static Acoustic fromJson(JsonObject json, AcousticsJsonParser context) {
        ArrayList<Integer> weights = new ArrayList<Integer>();
        ArrayList<Acoustic> acoustics = new ArrayList<Acoustic>();
        JsonArray sim = json.getAsJsonArray("array");
        Iterator iter = sim.iterator();
        while (iter.hasNext()) {
            JsonElement subElement = (JsonElement)iter.next();
            weights.add(subElement.getAsInt());
            if (!iter.hasNext()) {
                throw new JsonParseException("Probability has odd number of children!");
            }
            subElement = (JsonElement)iter.next();
            acoustics.add(context.solveAcoustic(subElement));
        }
        return new WeightedAcoustic(acoustics, weights);
    }
}

