/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.config.Variator;
import eu.ha3.presencefootsteps.mixins.ILivingEntity;
import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.acoustics.AcousticLibrary;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Solver;
import javax.annotation.Nullable;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;

class BipedalStepSoundGenerator
implements StepSoundGenerator {
    private double lastX;
    private double lastY;
    private double lastZ;
    protected double motionX;
    protected double motionY;
    protected double motionZ;
    protected Solver solver;
    protected AcousticLibrary acoustics;
    protected Variator variator;
    protected float dmwBase;
    protected float dwmYChange;
    protected double yPosition;
    protected boolean isAirborne;
    protected float fallDistance;
    protected float lastReference;
    protected boolean isImmobile;
    protected long timeImmobile;
    protected long immobilePlayback;
    protected int immobileInterval;
    protected boolean isRightFoot;
    protected double xMovec;
    protected double zMovec;
    protected boolean scalStat;
    private boolean stepThisFrame;
    private boolean isMessyFoliage;
    private long brushesTime;

    BipedalStepSoundGenerator() {
    }

    @Override
    public void setIsolator(Isolator isolator) {
        this.solver = isolator.getSolver();
        this.acoustics = isolator.getAcoustics();
        this.variator = isolator.getVariator();
    }

    @Override
    public boolean generateFootsteps(LivingEntity ply) {
        this.simulateMotionData(ply);
        this.simulateFootsteps(ply);
        this.simulateAirborne(ply);
        this.simulateBrushes(ply);
        this.simulateStationary(ply);
        return true;
    }

    protected void simulateStationary(LivingEntity ply) {
        Association assos;
        if (this.isImmobile && (ply.func_233570_aj_() || !ply.func_204231_K()) && this.playbackImmobile() && ((assos = this.solver.findAssociation((Entity)ply, 0.0, this.isRightFoot)).hasAssociation() || !this.isImmobile)) {
            this.solver.playAssociation((Entity)ply, assos, State.STAND);
        }
    }

    protected boolean playbackImmobile() {
        long now = System.currentTimeMillis();
        if (now - this.immobilePlayback > (long)this.immobileInterval) {
            this.immobilePlayback = now;
            this.immobileInterval = (int)Math.floor(Math.random() * (double)(this.variator.IMOBILE_INTERVAL_MAX - this.variator.IMOBILE_INTERVAL_MIN) + (double)this.variator.IMOBILE_INTERVAL_MIN);
            return true;
        }
        return false;
    }

    protected void simulateMotionData(LivingEntity ply) {
        if (PlayerUtil.isClientPlayer((Entity)ply)) {
            this.motionX = ply.func_213322_ci().field_72450_a;
            this.motionY = ply.func_213322_ci().field_72448_b;
            this.motionZ = ply.func_213322_ci().field_72449_c;
        } else {
            this.motionX = ply.func_226277_ct_() - this.lastX;
            this.lastX = ply.func_226277_ct_();
            this.motionY = ply.func_226278_cu_() - this.lastY;
            if (ply.func_233570_aj_()) {
                this.motionY += 0.0784000015258789;
            }
            this.lastY = ply.func_226278_cu_();
            this.motionZ = ply.func_226281_cx_() - this.lastZ;
            this.lastZ = ply.func_226281_cx_();
        }
        if (ply instanceof RemoteClientPlayerEntity && ply.field_70170_p.func_82737_E() % 1L == 0L) {
            ply.field_82151_R = this.motionX != 0.0 || this.motionZ != 0.0 ? (float)((double)ply.field_82151_R + (double)MathHelper.func_76133_a((double)(Math.pow(this.motionX, 2.0) + Math.pow(this.motionY, 2.0) + Math.pow(this.motionZ, 2.0))) * 0.8) : (float)((double)ply.field_82151_R + (double)MathHelper.func_76133_a((double)(Math.pow(this.motionX, 2.0) + Math.pow(this.motionZ, 2.0))) * 0.8);
            if (ply.func_233570_aj_()) {
                ply.field_70143_R = 0.0f;
            } else if (this.motionY < 0.0) {
                ply.field_70143_R = (float)((double)ply.field_70143_R - this.motionY * 200.0);
            }
        }
    }

    protected boolean stoppedImmobile(float reference) {
        float diff = this.lastReference - reference;
        this.lastReference = reference;
        if (!this.isImmobile && diff == 0.0f) {
            this.timeImmobile = System.currentTimeMillis();
            this.isImmobile = true;
        } else if (this.isImmobile && diff != 0.0f) {
            this.isImmobile = false;
            return System.currentTimeMillis() - this.timeImmobile > (long)this.variator.IMMOBILE_DURATION;
        }
        return false;
    }

    protected void simulateFootsteps(LivingEntity ply) {
        double movZ;
        double movX;
        double scal;
        float distanceReference = ply.field_82151_R;
        this.stepThisFrame = false;
        if (this.dmwBase > distanceReference) {
            this.dmwBase = 0.0f;
            this.dwmYChange = 0.0f;
        }
        if (this.scalStat != (scal = (movX = this.motionX) * this.xMovec + (movZ = this.motionZ) * this.zMovec) < (double)0.001f) {
            boolean bl = this.scalStat = !this.scalStat;
            if (this.scalStat && this.variator.PLAY_WANDER && !this.solver.hasStoppingConditions((Entity)ply)) {
                this.solver.playAssociation((Entity)ply, this.solver.findAssociation((Entity)ply, 0.0, this.isRightFoot), State.WANDER);
            }
        }
        this.xMovec = movX;
        this.zMovec = movZ;
        if (ply.func_233570_aj_() || ply.func_204231_K() || ply.func_70617_f_()) {
            State event = null;
            float dwm = distanceReference - this.dmwBase;
            boolean immobile = this.stoppedImmobile(distanceReference);
            if (immobile && !ply.func_70617_f_()) {
                dwm = 0.0f;
                this.dmwBase = distanceReference;
            }
            float distance = 0.0f;
            double verticalOffsetAsMinus = 0.0;
            if (ply.func_70617_f_() && !ply.func_233570_aj_()) {
                distance = this.variator.DISTANCE_LADDER;
            } else if (!ply.func_204231_K() && Math.abs(this.yPosition - ply.func_226278_cu_()) > 0.4) {
                if (this.yPosition < ply.func_226278_cu_()) {
                    distance = this.variator.DISTANCE_STAIR;
                    event = this.speedDisambiguator(ply, State.UP, State.UP_RUN);
                } else if (!ply.func_225608_bj_()) {
                    distance = -1.0f;
                    verticalOffsetAsMinus = 0.0;
                    event = this.speedDisambiguator(ply, State.DOWN, State.DOWN_RUN);
                }
                this.dwmYChange = distanceReference;
            } else {
                distance = this.variator.DISTANCE_HUMAN;
            }
            if (event == null) {
                event = this.speedDisambiguator(ply, State.WALK, State.RUN);
            }
            if (dwm > (distance = this.reevaluateDistance(event, distance))) {
                this.produceStep(ply, event, verticalOffsetAsMinus);
                this.stepped(ply, event);
                this.dmwBase = distanceReference;
            }
        }
        if (ply.func_233570_aj_()) {
            this.yPosition = ply.func_226278_cu_();
        }
    }

    protected void produceStep(LivingEntity ply, State event) {
        this.produceStep(ply, event, 0.0);
    }

    protected void produceStep(LivingEntity ply, @Nullable State event, double verticalOffsetAsMinus) {
        if (!this.solver.playStoppingConditions((Entity)ply)) {
            if (event == null) {
                event = this.speedDisambiguator(ply, State.WALK, State.RUN);
            }
            this.solver.playAssociation((Entity)ply, this.solver.findAssociation((Entity)ply, verticalOffsetAsMinus, this.isRightFoot), event);
            this.isRightFoot = !this.isRightFoot;
        }
        this.stepThisFrame = true;
    }

    protected void stepped(LivingEntity ply, State event) {
    }

    protected float reevaluateDistance(State event, float distance) {
        return distance;
    }

    protected void simulateAirborne(LivingEntity ply) {
        if ((ply.func_233570_aj_() || ply.func_70617_f_()) == this.isAirborne) {
            this.isAirborne = !this.isAirborne;
            this.simulateJumpingLanding(ply);
        }
        if (this.isAirborne) {
            this.fallDistance = ply.field_70143_R;
        }
    }

    protected boolean isJumping(LivingEntity ply) {
        return ((ILivingEntity)ply).isJumping();
    }

    protected double getOffsetMinus(LivingEntity ply) {
        if (ply instanceof RemoteClientPlayerEntity) {
            return 1.0;
        }
        return 0.0;
    }

    protected void simulateJumpingLanding(LivingEntity ply) {
        if (this.solver.hasStoppingConditions((Entity)ply)) {
            return;
        }
        if (this.isAirborne && this.isJumping(ply)) {
            this.simulateJumping(ply);
        } else if (!this.isAirborne) {
            this.simulateLanding(ply);
        }
    }

    protected void simulateJumping(LivingEntity ply) {
        if (this.variator.EVENT_ON_JUMP) {
            double speed = this.motionX * this.motionX + this.motionZ * this.motionZ;
            if (speed < (double)this.variator.SPEED_TO_JUMP_AS_MULTIFOOT) {
                this.playMultifoot(ply, this.getOffsetMinus(ply) + 0.4, State.JUMP);
            } else {
                this.playSinglefoot(ply, this.getOffsetMinus(ply) + 0.4, State.JUMP, this.isRightFoot);
            }
        }
    }

    protected void simulateLanding(LivingEntity ply) {
        if (this.fallDistance > this.variator.LAND_HARD_DISTANCE_MIN) {
            this.playMultifoot(ply, this.getOffsetMinus(ply), State.LAND);
        } else if (!ply.func_225608_bj_()) {
            this.playSinglefoot(ply, this.getOffsetMinus(ply), this.speedDisambiguator(ply, State.CLIMB, State.CLIMB_RUN), this.isRightFoot);
            if (!this.stepThisFrame) {
                this.isRightFoot = !this.isRightFoot;
            }
        }
    }

    protected State speedDisambiguator(LivingEntity ply, State walk, State run) {
        if (!PlayerUtil.isClientPlayer((Entity)ply)) {
            if (ply.func_70051_ag()) {
                return run;
            }
            return walk;
        }
        double velocity = this.motionX * this.motionX + this.motionZ * this.motionZ;
        return velocity > (double)this.variator.SPEED_TO_RUN ? run : walk;
    }

    private void simulateBrushes(LivingEntity ply) {
        if (this.brushesTime > System.currentTimeMillis()) {
            return;
        }
        this.brushesTime = System.currentTimeMillis() + 100L;
        if (this.motionX == 0.0 && this.motionZ == 0.0 || ply.func_225608_bj_()) {
            return;
        }
        Association assos = this.solver.findAssociation(ply.field_70170_p, new BlockPos(ply.func_226281_cx_(), ply.func_226278_cu_() - 0.1 - ply.func_70033_W() - (ply.func_233570_aj_() ? 0.0 : 0.25), ply.func_226281_cx_()), "find_messy_foliage");
        if (!assos.isNull()) {
            if (!this.isMessyFoliage) {
                this.isMessyFoliage = true;
                this.solver.playAssociation((Entity)ply, assos, State.WALK);
            }
        } else if (this.isMessyFoliage) {
            this.isMessyFoliage = false;
        }
    }

    protected void playSinglefoot(LivingEntity ply, double verticalOffsetAsMinus, State eventType, boolean foot) {
        Association assos = this.solver.findAssociation((Entity)ply, verticalOffsetAsMinus, this.isRightFoot);
        if (assos.isNotEmitter()) {
            assos = this.solver.findAssociation((Entity)ply, verticalOffsetAsMinus + 1.0, this.isRightFoot);
        }
        this.solver.playAssociation((Entity)ply, assos, eventType);
    }

    protected void playMultifoot(LivingEntity ply, double verticalOffsetAsMinus, State eventType) {
        Association leftFoot = this.solver.findAssociation((Entity)ply, verticalOffsetAsMinus, false);
        Association rightFoot = this.solver.findAssociation((Entity)ply, verticalOffsetAsMinus, true);
        if (leftFoot.hasAssociation() && leftFoot.equals(rightFoot)) {
            rightFoot = Association.NOT_EMITTER;
        }
        this.solver.playAssociation((Entity)ply, leftFoot, eventType);
        this.solver.playAssociation((Entity)ply, rightFoot, eventType);
    }
}

