/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.generator.BipedalStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.PegasusStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.QuadrapedalStepSoundGenerator;
import eu.ha3.presencefootsteps.sound.generator.StepSoundGenerator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;

public enum Locomotion {
    NONE(() -> StepSoundGenerator.EMPTY),
    BIPED(BipedalStepSoundGenerator::new),
    QUADRUPED(QuadrapedalStepSoundGenerator::new),
    FLYING(PegasusStepSoundGenerator::new);

    private static final Map<String, Locomotion> registry;
    private final Supplier<StepSoundGenerator> constructor;
    private static final String AUTO_TRANSLATION_KEY = "menu.pf.stance.auto";
    private final String translationKey = "menu.pf.stance." + this.name().toLowerCase();

    private Locomotion(Supplier<StepSoundGenerator> gen) {
        this.constructor = gen;
    }

    public StepSoundGenerator supplyGenerator() {
        return this.constructor.get();
    }

    public String getOptionName() {
        return I18n.func_135052_a((String)"menu.pf.stance", (Object[])new Object[]{I18n.func_135052_a((String)(this == NONE ? AUTO_TRANSLATION_KEY : this.translationKey), (Object[])new Object[0])});
    }

    public String getDisplayName() {
        return I18n.func_135052_a((String)"pf.stance", (Object[])new Object[]{I18n.func_135052_a((String)this.translationKey, (Object[])new Object[0])});
    }

    public static Locomotion byName(String name) {
        return registry.getOrDefault(name, BIPED);
    }

    public static Locomotion forLiving(Entity entity, Locomotion fallback) {
        return fallback;
    }

    public static Locomotion forPlayer(PlayerEntity ply, Locomotion preference) {
        if (preference == NONE) {
            return BIPED;
        }
        return preference;
    }

    static {
        registry = new HashMap<String, Locomotion>();
        for (Locomotion i : Locomotion.values()) {
            registry.put(i.name(), i);
            registry.put(String.valueOf(i.ordinal()), i);
        }
    }
}

