/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.QuadrapedalStepSoundGenerator;
import eu.ha3.presencefootsteps.util.MathUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;

class PegasusStepSoundGenerator
extends QuadrapedalStepSoundGenerator {
    protected boolean isFalling = false;
    protected FlightState state = FlightState.IDLE;
    protected int flapMod = 0;
    private long lastTimeImmobile;
    protected long nextFlapTime;

    PegasusStepSoundGenerator() {
    }

    @Override
    public boolean generateFootsteps(LivingEntity ply) {
        this.lastTimeImmobile = this.timeImmobile;
        return super.generateFootsteps(ply);
    }

    @Override
    protected void simulateAirborne(LivingEntity ply) {
        this.isFalling = this.motionY < -0.3;
        super.simulateAirborne(ply);
        if (this.isAirborne) {
            this.simulateFlying(ply);
        }
    }

    protected boolean updateState(double x, double y, double z, double strafe) {
        double smotionHor = x * x + z * z;
        float motionHor = (float)Math.sqrt(smotionHor);
        FlightState result = FlightState.IDLE;
        if (motionHor > this.variator.MIN_DASH_MOTION) {
            result = FlightState.DASHING;
        } else if (motionHor > this.variator.MIN_COAST_MOTION && (float)Math.abs(y) < this.variator.MIN_COAST_MOTION / 20.0f) {
            result = strafe > (double)this.variator.MIN_MOTION_Y ? FlightState.COASTING_STRAFING : FlightState.COASTING;
        } else if (motionHor > this.variator.MIN_MOTION_HOR) {
            result = FlightState.FLYING;
        } else if (y < 0.0) {
            result = FlightState.DESCENDING;
        } else if ((float)y > this.variator.MIN_MOTION_Y) {
            result = FlightState.ASCENDING;
        }
        boolean changed = result != this.state;
        this.state = result;
        return changed;
    }

    protected int getWingSpeed() {
        switch (this.state) {
            case COASTING: {
                if (this.flapMod == 0) {
                    return this.variator.WING_SPEED_COAST;
                }
                return this.variator.WING_SPEED_NORMAL * this.flapMod;
            }
            case COASTING_STRAFING: {
                return this.variator.WING_SPEED_NORMAL * (1 + this.flapMod);
            }
            case DASHING: {
                return this.variator.WING_SPEED_RAPID;
            }
            case ASCENDING: 
            case FLYING: {
                return this.variator.WING_SPEED_NORMAL;
            }
        }
        return this.variator.WING_SPEED_IDLE;
    }

    @Override
    protected void simulateJumpingLanding(LivingEntity ply) {
        boolean speedingJumpStateChange;
        if (this.solver.hasStoppingConditions((Entity)ply)) {
            return;
        }
        long now = System.currentTimeMillis();
        double xpd = this.motionX * this.motionX + this.motionZ * this.motionZ;
        float speed = (float)Math.sqrt(xpd);
        if (this.isAirborne) {
            this.nextFlapTime = now + (long)this.variator.WING_JUMPING_REST_TIME;
        }
        boolean hugeLanding = !this.isAirborne && this.fallDistance > this.variator.HUGEFALL_LANDING_DISTANCE_MIN;
        boolean bl = speedingJumpStateChange = speed > this.variator.MIN_MOTION_HOR;
        if (hugeLanding || speedingJumpStateChange) {
            if (!this.isAirborne) {
                float volume = speedingJumpStateChange ? 2.0f : MathUtil.scalex(this.fallDistance, this.variator.HUGEFALL_LANDING_DISTANCE_MIN, this.variator.HUGEFALL_LANDING_DISTANCE_MAX);
                this.acoustics.playAcoustic((Entity)ply, "_SWIFT", State.LAND, Options.singular("gliding_volume", Float.valueOf(volume)));
            } else {
                this.acoustics.playAcoustic((Entity)ply, "_SWIFT", State.JUMP, Options.EMPTY);
            }
        }
        if (this.isAirborne && this.isJumping(ply)) {
            this.simulateJumping(ply);
        } else if (!this.isAirborne && hugeLanding) {
            this.simulateLanding(ply);
        }
    }

    protected void simulateFlying(LivingEntity ply) {
        long now = System.currentTimeMillis();
        if (this.updateState(this.motionX, this.motionY, this.motionZ, ply.field_70702_br)) {
            this.nextFlapTime = now + (long)this.variator.FLIGHT_TRANSITION_TIME;
        }
        if (!ply.func_204231_K() && !this.isFalling && now > this.nextFlapTime) {
            this.nextFlapTime = now + (long)this.getWingSpeed() + (long)(ply.field_70170_p.field_73012_v.nextInt(100) - 50);
            this.flapMod = (this.flapMod + 1) % (1 + ply.field_70170_p.field_73012_v.nextInt(4));
            float volume = 1.0f;
            long diffImmobile = now - this.lastTimeImmobile;
            if (diffImmobile > (long)this.variator.WING_IMMOBILE_FADE_START) {
                volume -= MathUtil.scalex(diffImmobile, this.variator.WING_IMMOBILE_FADE_START, this.variator.WING_IMMOBILE_FADE_START + this.variator.WING_IMMOBILE_FADE_DURATION);
            }
            this.acoustics.playAcoustic((Entity)ply, "_WING", State.WALK, Options.singular("gliding_volume", Float.valueOf(volume)));
        }
    }

    private static enum FlightState {
        DASHING,
        COASTING,
        COASTING_STRAFING,
        FLYING,
        IDLE,
        ASCENDING,
        DESCENDING;

    }
}

