/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.generator;

import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.sound.generator.BipedalStepSoundGenerator;
import java.util.Random;
import net.minecraft.entity.LivingEntity;

class QuadrapedalStepSoundGenerator
extends BipedalStepSoundGenerator {
    private static final int STEPPING_FUNCTION = 2;
    private int hoof = 0;
    private float nextWalkDistanceMultiplier = 0.05f;
    private final Random rand = new Random();

    QuadrapedalStepSoundGenerator() {
    }

    @Override
    protected void stepped(LivingEntity ply, State event) {
        if (this.hoof == 0 || this.hoof == 2) {
            this.nextWalkDistanceMultiplier = this.rand.nextFloat();
        }
        this.hoof = (this.hoof + 1) % 3;
        if (event == State.WALK) {
            this.produceStep(ply, event);
        }
    }

    @Override
    protected float reevaluateDistance(State event, float distance) {
        if (event == State.WALK) {
            switch (2) {
                case 0: {
                    float overallMultiplier = 1.5f;
                    float ndm = 0.425f + this.nextWalkDistanceMultiplier * 0.15f;
                    if (this.hoof == 1 || this.hoof == 3) {
                        return distance * ndm * 1.5f;
                    }
                    return distance * (1.0f - ndm) * 1.5f;
                }
                case 1: {
                    float overallMultiplier = 1.4f;
                    float ndm = 0.5f;
                    if (this.hoof == 1 || this.hoof == 3) {
                        return distance * (0.5f + this.nextWalkDistanceMultiplier * 0.5f * 0.5f) * 1.4f;
                    }
                    return distance * 0.5f * 1.4f;
                }
                case 2: {
                    float overallMultiplier = 0.925f;
                    float ndm = 0.2f;
                    float pond = this.nextWalkDistanceMultiplier;
                    pond *= pond;
                    pond *= 0.2f;
                    if (this.hoof == 1 || this.hoof == 3) {
                        return distance * pond * 0.925f;
                    }
                    return distance * (1.0f - pond) * 0.925f;
                }
            }
        }
        if (event == State.RUN && this.hoof == 0) {
            return distance * 0.8f;
        }
        if (event == State.RUN) {
            return distance * 0.3f;
        }
        return distance;
    }
}

