/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.sound.player;

import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.player.DelayedSoundPlayer;
import eu.ha3.presencefootsteps.sound.player.SoundPlayer;
import eu.ha3.presencefootsteps.sound.player.StepSoundPlayer;
import eu.ha3.presencefootsteps.util.PlayerUtil;
import eu.ha3.presencefootsteps.world.Association;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;

public class ImmediateSoundPlayer
implements SoundPlayer,
StepSoundPlayer {
    private final Random random = new Random();
    private final DelayedSoundPlayer delayedPlayer = new DelayedSoundPlayer(this);

    @Override
    public Random getRNG() {
        return this.random;
    }

    @Override
    public void playStep(Association assos) {
        SoundType soundType = assos.getSoundGroup();
        if (!assos.getMaterial().func_76224_d() && soundType != null) {
            BlockState beside = assos.getSource().field_70170_p.func_180495_p(assos.getPos().func_177984_a());
            if (beside.func_177230_c() == Blocks.field_150433_aE) {
                soundType = Blocks.field_150433_aE.func_220072_p(beside);
            }
            this.playAttenuatedSound(assos.getSource(), soundType.func_185844_d().func_187503_a().toString(), soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
        }
    }

    @Override
    public void playSound(Entity location, String soundName, float volume, float pitch, Options options) {
        if (options.containsKey("delay_min") && options.containsKey("delay_max")) {
            this.delayedPlayer.playSound(location, soundName, volume, pitch, options);
            return;
        }
        this.playAttenuatedSound(location, soundName, volume, pitch);
    }

    private void playAttenuatedSound(Entity location, String soundName, float volume, float pitch) {
        Minecraft mc = Minecraft.func_71410_x();
        double distance = mc.field_71460_t.func_215316_n().func_216785_c().func_72436_e(location.func_213303_ch());
        volume = (float)((double)volume * ((100.0 - distance) / 100.0));
        SimpleSound sound = this.createSound(this.getSoundId(soundName, location), volume, pitch, location);
        if (distance > 100.0) {
            mc.func_147118_V().func_147681_a((ISound)sound, (int)Math.floor(Math.sqrt(distance) / 2.0));
        } else {
            mc.func_147118_V().func_147682_a((ISound)sound);
        }
    }

    @Override
    public void think() {
        this.delayedPlayer.think();
    }

    private SimpleSound createSound(ResourceLocation id, float volume, float pitch, Entity entity) {
        return new SimpleSound(id, SoundCategory.MASTER, volume, pitch, false, 0, ISound.AttenuationType.LINEAR, (double)((float)entity.func_226277_ct_()), (double)((float)entity.func_226278_cu_()), (double)((float)entity.func_226281_cx_()), false);
    }

    private ResourceLocation getSoundId(String name, Entity location) {
        if (name.indexOf(58) >= 0) {
            return new ResourceLocation(name);
        }
        String domain = "presencefootsteps";
        if (!PlayerUtil.isClientPlayer(location)) {
            domain = domain + "mono";
        }
        return new ResourceLocation(domain, name);
    }
}

