/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.util;

import com.google.gson.stream.JsonWriter;
import com.minelittlepony.common.util.GamePaths;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractPressurePlateBlock;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.BushBlock;
import net.minecraft.block.CarpetBlock;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.PaneBlock;
import net.minecraft.block.SilverfishBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.block.SpreadableSnowyDirtBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;

public class BlockReport {
    private final Path loc;

    public BlockReport(String baseName) {
        this.loc = BlockReport.getUniqueFileName(GamePaths.getGameDirectory().resolve("presencefootsteps"), baseName, ".json");
    }

    public void execute(@Nullable Predicate<BlockState> filter) {
        try {
            this.writeReport(filter);
            this.printResults();
        }
        catch (Exception e) {
            BlockReport.addMessage((ITextComponent)new TranslationTextComponent("pf.report.error", new Object[]{e.getMessage()}).func_240700_a_(s -> s.func_240712_a_(TextFormatting.RED)));
        }
    }

    private void writeReport(@Nullable Predicate<BlockState> filter) throws IOException {
        Files.createDirectories(this.loc.getParent(), new FileAttribute[0]);
        try (JsonWriter writer = new JsonWriter((Writer)Files.newBufferedWriter(this.loc, new OpenOption[0]));){
            writer.setIndent("    ");
            writer.beginObject();
            writer.name("blocks");
            writer.beginObject();
            Registry.field_212618_g.forEach(block -> {
                BlockState state = block.func_176223_P();
                try {
                    if (filter == null || filter.test(state)) {
                        writer.name(Registry.field_212618_g.func_177774_c(block).toString());
                        writer.beginObject();
                        writer.name("class");
                        writer.value(this.getClassData(state));
                        writer.name("sound");
                        writer.value(this.getSoundData(state));
                        writer.name("association");
                        writer.value(PresenceFootsteps.getInstance().getEngine().getIsolator().getBlockMap().getAssociation(state, ""));
                        writer.endObject();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.endObject();
            writer.name("unmapped_entities");
            writer.beginArray();
            Registry.field_212629_r.forEach(type -> {
                if (type.func_200721_a((World)Minecraft.func_71410_x().field_71441_e) instanceof LivingEntity) {
                    ResourceLocation id = Registry.field_212629_r.func_177774_c(type);
                    if (!PresenceFootsteps.getInstance().getEngine().getIsolator().getLocomotionMap().contains(id)) {
                        try {
                            writer.value(id.toString());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
            writer.endArray();
            writer.endObject();
        }
    }

    private String getSoundData(BlockState state) {
        if (state.func_215695_r() == null) {
            return "NULL";
        }
        if (state.func_215695_r().func_185844_d() == null) {
            return "NO_SOUND";
        }
        return state.func_215695_r().func_185844_d().func_187503_a().func_110623_a();
    }

    private String getClassData(BlockState state) {
        Block block = state.func_177230_c();
        String soundName = "";
        if (block instanceof AbstractPressurePlateBlock) {
            soundName = soundName + ",EXTENDS_PRESSURE_PLATE";
        }
        if (block instanceof AbstractRailBlock) {
            soundName = soundName + ",EXTENDS_RAIL";
        }
        if (block instanceof ContainerBlock) {
            soundName = soundName + ",EXTENDS_CONTAINER";
        }
        if (block instanceof FlowingFluidBlock) {
            soundName = soundName + ",EXTENDS_LIQUID";
        }
        if (block instanceof BushBlock) {
            soundName = soundName + ",EXTENDS_PLANT";
        }
        if (block instanceof DoublePlantBlock) {
            soundName = soundName + ",EXTENDS_DOUBLE_PLANT";
        }
        if (block instanceof SixWayBlock) {
            soundName = soundName + ",EXTENDS_CONNECTED_PLANT";
        }
        if (block instanceof LeavesBlock) {
            soundName = soundName + ",EXTENDS_LEAVES";
        }
        if (block instanceof SlabBlock) {
            soundName = soundName + ",EXTENDS_SLAB";
        }
        if (block instanceof StairsBlock) {
            soundName = soundName + ",EXTENDS_STAIRS";
        }
        if (block instanceof SnowyDirtBlock) {
            soundName = soundName + ",EXTENDS_SNOWY";
        }
        if (block instanceof SpreadableSnowyDirtBlock) {
            soundName = soundName + ",EXTENDS_SPREADABLE";
        }
        if (block instanceof FallingBlock) {
            soundName = soundName + ",EXTENDS_PHYSICALLY_FALLING";
        }
        if (block instanceof PaneBlock) {
            soundName = soundName + ",EXTENDS_PANE";
        }
        if (block instanceof HorizontalBlock) {
            soundName = soundName + ",EXTENDS_PILLAR";
        }
        if (block instanceof TorchBlock) {
            soundName = soundName + ",EXTENDS_TORCH";
        }
        if (block instanceof CarpetBlock) {
            soundName = soundName + ",EXTENDS_CARPET";
        }
        if (block instanceof SilverfishBlock) {
            soundName = soundName + ",EXTENDS_INFESTED";
        }
        if (block instanceof BreakableBlock) {
            soundName = soundName + ",EXTENDS_TRANSPARENT";
        }
        return soundName;
    }

    private void printResults() {
        BlockReport.addMessage((ITextComponent)new TranslationTextComponent("pf.report.save").func_230529_a_((ITextComponent)new StringTextComponent(this.loc.getFileName().toString()).func_240700_a_(s -> s.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, this.loc.toString())).func_240721_b_(TextFormatting.UNDERLINE))).func_240700_a_(s -> s.func_240712_a_(TextFormatting.GREEN)));
    }

    public static void addMessage(ITextComponent text) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a(text);
    }

    static Path getUniqueFileName(Path directory, String baseName, String ext) {
        Path loc = null;
        int counter = 0;
        while (loc == null || Files.exists(loc, new LinkOption[0])) {
            loc = directory.resolve(baseName + (counter == 0 ? "" : "_" + counter) + ext);
            ++counter;
        }
        return loc;
    }
}

