/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Emitter;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;

public class Association {
    public static final Association NOT_EMITTER = new Association();
    private final BlockState blockState;
    private final BlockPos pos;
    private String data = "NOT_EMITTER";
    private Entity source;

    public Association() {
        this(Blocks.field_150350_a.func_176223_P(), BlockPos.field_177992_a);
    }

    public Association(BlockState state, BlockPos pos) {
        this.blockState = state;
        this.pos = pos;
    }

    public Association at(Entity source) {
        if (!this.isNull()) {
            this.source = source;
        }
        return this;
    }

    public Association with(@Nullable String data) {
        if (!this.isNull() && data != null) {
            this.data = data;
        }
        return this;
    }

    public boolean isNull() {
        return this == NOT_EMITTER;
    }

    public boolean isNotEmitter() {
        return this.isNull() || Emitter.isNonEmitter(this.data);
    }

    public boolean hasAssociation() {
        return !this.isNotEmitter() && Emitter.isResult(this.data);
    }

    public String getAcousticName() {
        return this.data;
    }

    public Entity getSource() {
        return this.source;
    }

    public Material getMaterial() {
        return this.blockState.func_185904_a();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public SoundType getSoundGroup() {
        return this.blockState.func_215695_r();
    }
}

