/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.world.Lookup;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;

public class GolemLookup
implements Lookup<EntityType<?>> {
    private final Map<String, Map<ResourceLocation, String>> substrates = new LinkedHashMap<String, Map<ResourceLocation, String>>();

    @Override
    public String getAssociation(EntityType<?> key, String substrate) {
        Map<ResourceLocation, String> primitives = this.substrates.get(substrate);
        if (primitives == null) {
            primitives = this.substrates.get("");
        }
        if (primitives == null) {
            return "UNASSIGNED";
        }
        return primitives.getOrDefault(EntityType.func_200718_a(key), "UNASSIGNED");
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public void add(String key, String value) {
        String[] split = key.trim().split("@");
        String primitive = split[0];
        String substrate = split.length > 1 ? split[1] : "";
        this.substrates.computeIfAbsent(substrate, s -> new LinkedHashMap()).put(new ResourceLocation(primitive), value);
    }

    @Override
    public boolean contains(EntityType<?> key) {
        ResourceLocation primitive = EntityType.func_200718_a(key);
        for (Map<ResourceLocation, String> primitives : this.substrates.values()) {
            if (!primitives.containsKey(primitive)) continue;
            return true;
        }
        return false;
    }
}

