/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import eu.ha3.presencefootsteps.sound.Isolator;
import eu.ha3.presencefootsteps.sound.Options;
import eu.ha3.presencefootsteps.sound.State;
import eu.ha3.presencefootsteps.world.Association;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Solver;
import java.util.List;
import java.util.Locale;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PFSolver
implements Solver {
    private static final Logger logger = LogManager.getLogger((String)"PFSolver");
    private static final double TRAP_DOOR_OFFSET = 0.1;
    private final Isolator isolator;

    public PFSolver(Isolator isolator) {
        this.isolator = isolator;
    }

    @Override
    public void playAssociation(Entity ply, Association assos, State eventType) {
        if (assos.isNotEmitter()) {
            return;
        }
        if ((assos = assos.at(ply)).hasAssociation()) {
            this.isolator.getAcoustics().playAcoustic(assos, eventType, Options.EMPTY);
        } else {
            this.isolator.getStepPlayer().playStep(assos);
        }
    }

    @Override
    public Association findAssociation(Entity ply, double verticalOffsetAsMinus, boolean isRightFoot) {
        double rot = Math.toRadians(MathHelper.func_76142_g((float)ply.field_70177_z));
        Vector3d pos = ply.func_213303_ch();
        float feetDistanceToCenter = 0.2f * (float)(isRightFoot ? -1 : 1);
        return this.findAssociation(ply, new BlockPos(pos.field_72450_a + Math.cos(rot) * (double)feetDistanceToCenter, ply.func_174813_aQ().func_197745_a(Direction.Axis.Y) - 0.1 - verticalOffsetAsMinus, pos.field_72449_c + Math.sin(rot) * (double)feetDistanceToCenter));
    }

    private Association findAssociation(Entity player, BlockPos pos) {
        boolean isXdangMax;
        if (!(player instanceof RemoteClientPlayerEntity)) {
            Vector3d vel = player.func_213322_ci();
            if ((vel.field_72450_a != 0.0 || vel.field_72448_b != 0.0 || vel.field_72449_c != 0.0) && Math.abs(vel.field_72448_b) < 0.02) {
                return Association.NOT_EMITTER;
            }
        }
        AxisAlignedBB collider = player.func_174813_aQ();
        collider = collider.func_72317_d(0.0, -(collider.field_72338_b - Math.floor(collider.field_72338_b)), 0.0);
        Association worked = this.findAssociation(player.field_70170_p, pos, collider = collider.func_186662_g(0.1));
        if (!worked.isNull()) {
            return worked;
        }
        double xdang = (player.func_226277_ct_() - (double)pos.func_177958_n()) * 2.0 - 1.0;
        double zdang = (player.func_226281_cx_() - (double)pos.func_177952_p()) * 2.0 - 1.0;
        if (Math.max(Math.abs(xdang), Math.abs(zdang)) <= (double)0.2f) {
            return worked;
        }
        boolean bl = isXdangMax = Math.abs(xdang) > Math.abs(zdang);
        worked = isXdangMax ? this.findAssociation(player.field_70170_p, pos.func_177965_g(xdang > 0.0 ? 1 : -1), collider) : this.findAssociation(player.field_70170_p, pos.func_177970_e(zdang > 0.0 ? 1 : -1), collider);
        if (!worked.isNull()) {
            return worked;
        }
        if (isXdangMax) {
            return this.findAssociation(player.field_70170_p, pos.func_177964_d(zdang > 0.0 ? 1 : -1), collider);
        }
        return this.findAssociation(player.field_70170_p, pos.func_177965_g(xdang > 0.0 ? 1 : -1), collider);
    }

    private String findForGolem(World world, BlockPos pos, String substrate) {
        String golem;
        List golems = world.func_175647_a(Entity.class, new AxisAlignedBB(pos), e -> !(e instanceof PlayerEntity));
        if (!golems.isEmpty() && Emitter.isEmitter(golem = this.isolator.getGolemMap().getAssociation(((Entity)golems.get(0)).func_200600_R(), substrate))) {
            logger.debug("Golem detected: " + golem);
            return golem;
        }
        return "UNASSIGNED";
    }

    private Association findAssociation(World world, BlockPos pos, AxisAlignedBB collider) {
        String wet;
        BlockState in = world.func_180495_p(pos);
        BlockPos up = pos.func_177984_a();
        BlockState above = world.func_180495_p(up);
        String association = this.findForGolem(world, up, "carpet");
        if (!Emitter.isEmitter(association)) {
            association = this.isolator.getBlockMap().getAssociation(above, "carpet");
        }
        if (Emitter.isEmitter(association)) {
            logger.debug("Carpet detected: " + association);
            pos = up;
            in = above;
        } else {
            String foliage;
            VoxelShape shape;
            Material mat = in.func_185904_a();
            if (mat == Material.field_151579_a || mat == Material.field_151594_q) {
                BlockPos down = pos.func_177977_b();
                BlockState below = world.func_180495_p(down);
                association = this.isolator.getBlockMap().getAssociation(below, "bigger");
                if (Emitter.isResult(association)) {
                    logger.debug("Fence detected: " + association);
                    pos = down;
                    in = below;
                }
            }
            if ((shape = in.func_196952_d((IBlockReader)world, pos)).func_197766_b()) {
                shape = in.func_196954_c((IBlockReader)world, pos);
            }
            if (!shape.func_197766_b() && !shape.func_197752_a().func_186670_a(pos).func_72326_a(collider)) {
                return Association.NOT_EMITTER;
            }
            if (!Emitter.isResult(association) && !Emitter.isEmitter(association = this.findForGolem(world, pos, ""))) {
                association = this.isolator.getBlockMap().getAssociation(in, "");
            }
            if (Emitter.isEmitter(association) && Emitter.isEmitter(foliage = this.isolator.getBlockMap().getAssociation(above, "foliage"))) {
                logger.debug("Foliage detected: " + foliage);
                association = association + "," + foliage;
            }
        }
        if (Emitter.isEmitter(association) && (world.func_175727_C(up) || in.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a) || above.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a)) && Emitter.isEmitter(wet = this.isolator.getBlockMap().getAssociation(in, "wet"))) {
            logger.debug("Wet block detected: " + wet);
            association = association + "," + wet;
        }
        if (Emitter.isNonEmitter(association)) {
            return Association.NOT_EMITTER;
        }
        if (Emitter.isResult(association)) {
            return new Association(in, pos).with(association);
        }
        if (in.func_196958_f()) {
            return Association.NOT_EMITTER;
        }
        SoundType sounds = in.func_215695_r();
        String substrate = String.format(Locale.ENGLISH, "%.2f_%.2f", Float.valueOf(sounds.field_185860_m), Float.valueOf(sounds.field_185861_n));
        String primitive = this.isolator.getPrimitiveMap().getAssociation(sounds, substrate);
        if (Emitter.isNonEmitter(primitive)) {
            return Association.NOT_EMITTER;
        }
        return new Association(in, pos).with(primitive);
    }

    @Override
    public boolean playStoppingConditions(Entity ply) {
        if (!this.hasStoppingConditions(ply)) {
            return false;
        }
        float volume = Math.min(1.0f, (float)ply.func_213322_ci().func_72433_c() * 0.35f);
        Options options = Options.singular("gliding_volume", Float.valueOf(volume));
        State state = ply.func_204231_K() ? State.SWIM : State.WALK;
        this.isolator.getAcoustics().playAcoustic(ply, "_SWIM", state, options);
        return true;
    }

    @Override
    public boolean hasStoppingConditions(Entity ply) {
        return ply.func_204231_K();
    }

    @Override
    public Association findAssociation(World world, BlockPos pos, String strategy) {
        if (!"find_messy_foliage".equals(strategy)) {
            return Association.NOT_EMITTER;
        }
        BlockState above = world.func_180495_p(pos.func_177984_a());
        String foliage = this.isolator.getBlockMap().getAssociation(above, "foliage");
        if (!Emitter.isEmitter(foliage)) {
            return Association.NOT_EMITTER;
        }
        if ("MESSY_GROUND".equals(this.isolator.getBlockMap().getAssociation(above, "messy"))) {
            return new Association().with(foliage);
        }
        return Association.NOT_EMITTER;
    }
}

