/*
 * Decompiled with CFR 0.152.
 */
package eu.ha3.presencefootsteps.world;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import eu.ha3.presencefootsteps.PresenceFootsteps;
import eu.ha3.presencefootsteps.world.Emitter;
import eu.ha3.presencefootsteps.world.Lookup;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class StateLookup
implements Lookup<BlockState> {
    private final Map<String, Bucket> substrates = new LinkedHashMap<String, Bucket>();

    @Override
    public String getAssociation(BlockState state, String substrate) {
        return this.substrates.getOrDefault((Object)substrate, (Bucket)Bucket.EMPTY).get((BlockState)state).value;
    }

    @Override
    public void add(String key, String value) {
        if (!Emitter.isResult(value)) {
            PresenceFootsteps.logger.info("Skipping non-result value " + key + "=" + value);
            return;
        }
        Key k = new Key(key, value);
        this.substrates.computeIfAbsent(k.substrate, Bucket.Substrate::new).add(k);
    }

    @Override
    public Set<String> getSubstrates() {
        return this.substrates.keySet();
    }

    @Override
    public boolean contains(BlockState state) {
        for (Bucket substrate : this.substrates.values()) {
            if (!substrate.contains(state)) continue;
            return true;
        }
        return false;
    }

    private static final class Key {
        public static final Key NULL = new Key();
        public final ResourceLocation identifier;
        public final String substrate;
        private final Set<Attribute> properties;
        public final String value;
        private final boolean empty;
        public final boolean isTag;
        public final boolean isWildcard;

        private Key() {
            this.identifier = new ResourceLocation("air");
            this.substrate = "";
            this.properties = Collections.emptySet();
            this.value = "UNASSIGNED";
            this.empty = true;
            this.isTag = false;
            this.isWildcard = false;
        }

        Key(String key, String value) {
            String substrate;
            String id;
            this.value = value;
            boolean bl = this.isTag = key.indexOf(35) == 0;
            if (this.isTag) {
                key = key.replaceFirst("#", "");
            }
            boolean bl2 = this.isWildcard = (id = key.split("[\\.\\[]")[0]).indexOf(42) == 0;
            if (!this.isWildcard) {
                if (id.indexOf(94) > -1) {
                    this.identifier = new ResourceLocation(id.split("\\^")[0]);
                    PresenceFootsteps.logger.warn("Metadata entry for " + key + "=" + value + " was ignored");
                } else {
                    this.identifier = new ResourceLocation(id);
                }
                if (!this.isTag && !Registry.field_212618_g.func_212607_c(this.identifier)) {
                    PresenceFootsteps.logger.warn("Sound registered for unknown block id " + this.identifier);
                }
            } else {
                this.identifier = new ResourceLocation("air");
            }
            if ((substrate = (key = key.replace(id, "")).replaceFirst("\\[[^\\]]+\\]", "")).indexOf(46) > -1) {
                this.substrate = substrate.split("\\.")[1];
                key = key.replace(substrate, "");
            } else {
                this.substrate = "";
            }
            this.properties = Lists.newArrayList((Object[])key.replace("[", "").replace("]", "").split(",")).stream().filter(line -> line.indexOf(61) > -1).map(Attribute::new).collect(Collectors.toSet());
            this.empty = this.properties.isEmpty();
        }

        boolean matches(BlockState state) {
            if (this.empty) {
                return true;
            }
            ImmutableMap entries = state.func_206871_b();
            Set keys = entries.keySet();
            for (Attribute property : this.properties) {
                for (Property key : keys) {
                    Comparable value;
                    if (!key.func_177701_a().equals(property.name) || Objects.toString(value = (Comparable)entries.get(key)).equals(property.value)) continue;
                    return false;
                }
            }
            return true;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.empty ? 1231 : 1237);
            result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
            result = 31 * result + (this.isTag ? 1231 : 1237);
            result = 31 * result + (this.isWildcard ? 1231 : 1237);
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            result = 31 * result + (this.substrate == null ? 0 : this.substrate.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj || obj != null && this.getClass() == obj.getClass() && this.equals((Key)obj);
        }

        private boolean equals(Key other) {
            return this.isTag == other.isTag && this.isWildcard == other.isWildcard && this.empty == other.empty && Objects.equals(this.identifier, other.identifier) && Objects.equals(this.substrate, other.substrate) && Objects.equals(this.properties, other.properties);
        }

        private static class Attribute {
            private final String name;
            private final String value;

            Attribute(String prop) {
                String[] split = prop.split("=");
                this.name = split[0];
                this.value = split[1];
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
                result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
                return result;
            }

            public boolean equals(Object obj) {
                return this == obj || obj != null && this.getClass() == obj.getClass() && this.equals((Attribute)obj);
            }

            private boolean equals(Attribute other) {
                return Objects.equals(this.name, other.name) && Objects.equals(this.value, other.value);
            }
        }
    }

    private static final class KeyList {
        private final Set<Key> keys = new LinkedHashSet<Key>();

        private KeyList() {
        }

        void add(Key key) {
            this.keys.remove(key);
            this.keys.add(key);
        }

        public Key findMatch(BlockState state) {
            for (Key i : this.keys) {
                if (!i.matches(state)) continue;
                return i;
            }
            return Key.NULL;
        }
    }

    private static interface Bucket {
        public static final Bucket EMPTY = state -> Key.NULL;

        default public void add(Key key) {
        }

        public Key get(BlockState var1);

        default public boolean contains(BlockState state) {
            return false;
        }

        public static final class Tile
        implements Bucket {
            private final Map<BlockState, Key> cache = new LinkedHashMap<BlockState, Key>();
            private final KeyList keys = new KeyList();

            Tile(ResourceLocation id) {
            }

            @Override
            public void add(Key key) {
                this.keys.add(key);
            }

            @Override
            public Key get(BlockState state) {
                return this.cache.computeIfAbsent(state, this.keys::findMatch);
            }

            @Override
            public boolean contains(BlockState state) {
                return this.get(state) != Key.NULL;
            }
        }

        public static final class Substrate
        implements Bucket {
            private final KeyList wildcards = new KeyList();
            private final Map<ResourceLocation, Bucket> blocks = new LinkedHashMap<ResourceLocation, Bucket>();
            private final Map<ResourceLocation, Bucket> tags = new LinkedHashMap<ResourceLocation, Bucket>();

            Substrate(String substrate) {
            }

            @Override
            public void add(Key key) {
                if (key.isWildcard) {
                    this.wildcards.add(key);
                } else {
                    (key.isTag ? this.tags : this.blocks).computeIfAbsent(key.identifier, Tile::new).add(key);
                }
            }

            @Override
            public Key get(BlockState state) {
                Key association = this.getTile(state).get(state);
                if (association == Key.NULL) {
                    return this.wildcards.findMatch(state);
                }
                return association;
            }

            @Override
            public boolean contains(BlockState state) {
                return this.getTile(state).contains(state);
            }

            private Bucket getTile(BlockState state) {
                return this.blocks.computeIfAbsent(Registry.field_212618_g.func_177774_c((Object)state.func_177230_c()), id -> {
                    Block block = (Block)Registry.field_212618_g.func_82594_a(id);
                    for (ResourceLocation tag : this.tags.keySet()) {
                        if (!BlockTags.func_199896_a().func_241834_b(tag).func_230235_a_((Object)block)) continue;
                        return this.tags.get(tag);
                    }
                    return EMPTY;
                });
            }
        }
    }
}

