/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.client.util;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1159;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class SimpleFluidRenderer {
    private static final Map<class_3611, FluidRenderingData> FLUID_DATA = new HashMap<class_3611, FluidRenderingData>();

    private SimpleFluidRenderer() {
    }

    @Nullable
    public static FluidRenderingData fromFluid(class_3611 fluid) {
        return FLUID_DATA.computeIfAbsent(fluid, FluidRenderingDataImpl::from);
    }

    public static void render(class_3611 fluid, class_4587 matrices, int x0, int y0, int width, int height, int zOffset) {
        block4: {
            FluidRenderingData renderingData = SimpleFluidRenderer.fromFluid(fluid);
            if (renderingData == null) break block4;
            class_1058 sprite = renderingData.getSprite();
            int color = renderingData.getColor();
            int a = 255;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            class_310.method_1551().method_1531().method_22813(class_1059.field_5275);
            class_289 tess = class_289.method_1348();
            class_287 bb = tess.method_1349();
            class_1159 matrix = matrices.method_23760().method_23761();
            if (height / width >= 1) {
                int times = (int)Math.ceil((double)height / (double)width);
                for (int i = 0; i < times; ++i) {
                    int newY0 = y0 + i * width;
                    int newY1 = Math.min(newY0 + width, y0 + height);
                    bb.method_1328(7, class_290.field_1575);
                    bb.method_22918(matrix, (float)(x0 + width), (float)newY0, (float)zOffset).method_22913(sprite.method_4577(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)x0, (float)newY0, (float)zOffset).method_22913(sprite.method_4594(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)x0, (float)newY1, (float)zOffset).method_22913(sprite.method_4594(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)(x0 + width), (float)newY1, (float)zOffset).method_22913(sprite.method_4577(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
                    tess.method_1350();
                }
            } else {
                int times = Math.min((int)Math.ceil((double)width / (double)height), 3);
                for (int i = 0; i < times; ++i) {
                    int newX0 = x0 + i * Math.max(height, width / 3);
                    int newX1 = Math.min(newX0 + Math.max(height, width / 3 + 1), x0 + width);
                    bb.method_1328(7, class_290.field_1575);
                    bb.method_22918(matrix, (float)newX1, (float)y0, (float)zOffset).method_22913(sprite.method_4577(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)newX0, (float)y0, (float)zOffset).method_22913(sprite.method_4594(), sprite.method_4593()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)newX0, (float)(y0 + height), (float)zOffset).method_22913(sprite.method_4594(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
                    bb.method_22918(matrix, (float)newX1, (float)(y0 + height), (float)zOffset).method_22913(sprite.method_4577(), sprite.method_4575()).method_1336(r, g, b, a).method_1344();
                    tess.method_1350();
                }
            }
        }
    }

    public static final class FluidRenderingDataImpl
    implements FluidRenderingData {
        private final class_1058 sprite;
        private final int color;

        public FluidRenderingDataImpl(class_1058 sprite, int color) {
            this.sprite = sprite;
            this.color = color;
        }

        public static FluidRenderingData from(class_3611 fluid) {
            FluidRenderHandler fluidRenderHandler = FluidRenderHandlerRegistry.INSTANCE.get(fluid);
            if (fluidRenderHandler == null) {
                return null;
            }
            class_1058[] sprites = fluidRenderHandler.getFluidSprites((class_1920)class_310.method_1551().field_1687, class_310.method_1551().field_1687 == null ? null : class_2338.field_10980, fluid.method_15785());
            int color = -1;
            if (class_310.method_1551().field_1687 != null) {
                color = fluidRenderHandler.getFluidColor((class_1920)class_310.method_1551().field_1687, class_2338.field_10980, fluid.method_15785());
            }
            return new FluidRenderingDataImpl(sprites[0], color);
        }

        @Override
        public class_1058 getSprite() {
            return this.sprite;
        }

        @Override
        public int getColor() {
            return this.color;
        }
    }

    public static interface FluidRenderingData {
        public class_1058 getSprite();

        public int getColor();
    }
}

