/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.inventory;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2350;

public enum IOType {
    INPUT(1, true, false),
    OUTPUT(0, false, true),
    BOTH(2, true, true),
    NEITHER(3, false, false);

    private final int index;
    private final boolean insert;
    private final boolean extract;

    private IOType(int i, boolean insert, boolean extract) {
        this.index = i;
        this.insert = insert;
        this.extract = extract;
    }

    public static IOType byId(int id) {
        for (IOType type : IOType.values()) {
            if (type.index != id) continue;
            return type;
        }
        throw new AssertionError((Object)"Invalid id");
    }

    public static Map<class_2350, IOType> intToMap(int n) {
        int[] array = IOType.fromInt(n, 6);
        HashMap<class_2350, IOType> result = new HashMap<class_2350, IOType>();
        result.put(class_2350.field_11043, IOType.byId(array[0]));
        result.put(class_2350.field_11039, IOType.byId(array[1]));
        result.put(class_2350.field_11034, IOType.byId(array[2]));
        result.put(class_2350.field_11036, IOType.byId(array[3]));
        result.put(class_2350.field_11033, IOType.byId(array[4]));
        result.put(class_2350.field_11035, IOType.byId(array[5]));
        return result;
    }

    public static int mapToInt(Map<class_2350, IOType> map) {
        int[] array = new int[]{map.get((Object)class_2350.field_11043).index, map.get((Object)class_2350.field_11039).index, map.get((Object)class_2350.field_11034).index, map.get((Object)class_2350.field_11036).index, map.get((Object)class_2350.field_11033).index, map.get((Object)class_2350.field_11035).index};
        return IOType.toInt(array);
    }

    public static int toInt(int[] arr) {
        int n = 0;
        int i = -1;
        while (i < arr.length - 1) {
            n = (int)((double)n + (double)arr[++i] * Math.pow(IOType.values().length, i));
        }
        return n;
    }

    public static int[] fromInt(int n, int size) {
        int[] result = new int[size];
        int i = size - 1;
        int c = (int)Math.pow(IOType.values().length, i);
        while (i-- >= 0) {
            result[i + 1] = c > 0 ? n / c : 0;
            n %= c;
            c /= IOType.values().length;
        }
        return result;
    }

    public boolean canInsert() {
        return this.insert;
    }

    public boolean canExtract() {
        return this.extract;
    }

    public int getIndex() {
        return this.index;
    }
}

