/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.inventory.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2348;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class FilterInventory
implements class_1263 {
    private final int height;
    public class_2371<class_1799> items;
    private boolean matchNbt;
    private boolean matchMod;
    private int filterType;

    public FilterInventory(class_2371<class_1799> items, int filterType, int height, boolean matchNbt, boolean matchMod) {
        this.items = items;
        this.filterType = filterType;
        this.height = height;
        this.matchNbt = matchNbt;
        this.matchMod = matchMod;
    }

    public static FilterInventory fromTag(class_2487 tag, int defaultHeight) {
        int height = tag.method_10545("height") ? tag.method_10550("height") : defaultHeight;
        int filterType = tag.method_10550("type");
        boolean matchNbt = tag.method_10577("nbtMatch");
        boolean matchMod = tag.method_10577("modMatch");
        class_2371 items = class_2371.method_10213((int)(height * 9), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, (class_2371)items);
        return new FilterInventory((class_2371<class_1799>)items, filterType, height, matchNbt, matchMod);
    }

    public int method_5444() {
        return 1;
    }

    public void method_5448() {
        this.items.clear();
    }

    public int getInventoryWidth() {
        return 9;
    }

    public int getInventoryHeight() {
        return this.height;
    }

    public int method_5439() {
        return this.getInventoryWidth() * this.getInventoryHeight();
    }

    public boolean method_5442() {
        return this.items.stream().allMatch(class_1799::method_7960);
    }

    public boolean put(class_1799 stack) {
        class_1799 copy = stack.method_7972();
        copy.method_7939(1);
        if (!this.matchNbt && this.method_18862(Collections.singleton(stack.method_7909()))) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((class_1799)this.items.get(i)).method_7960()) continue;
            this.items.set(i, (Object)copy);
            return true;
        }
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        return class_1262.method_5430(this.items, (int)slot, (int)amount);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        stack.method_7939(1);
        this.items.set(slot, (Object)stack);
    }

    public void method_5431() {
        this.fixItems();
    }

    private void fixItems() {
        class_2371 fixed = class_2371.method_10213((int)this.items.size(), (Object)class_1799.field_8037);
        int index = 0;
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            fixed.set(index++, (Object)stack);
        }
        this.items = fixed;
    }

    public Set<class_1792> getFilterItems() {
        HashSet<class_1792> res = new HashSet<class_1792>();
        for (class_1799 item : this.items) {
            res.add(item.method_7909());
        }
        res.remove(class_1802.field_8162);
        return res;
    }

    public boolean passFilterTest(class_1799 stack) {
        boolean bl;
        Set<class_1792> filterItems = this.getFilterItems();
        if (this.matchMod) {
            Set mods = filterItems.stream().map(arg_0 -> ((class_2348)class_2378.field_11142).method_10221(arg_0)).map(class_2960::method_12836).collect(Collectors.toSet());
            String itemId = class_2378.field_11142.method_10221((Object)stack.method_7909()).method_12836();
            return this.filterType == 0 == mods.contains(itemId);
        }
        boolean bl2 = bl = this.filterType == 0 == filterItems.contains(stack.method_7909());
        if (!this.matchNbt) {
            return bl;
        }
        if (!bl) {
            return false;
        }
        Set stacks = this.items.stream().filter(i -> !i.method_7960()).collect(Collectors.toSet());
        for (class_1799 test : stacks) {
            if (test.method_7909() != stack.method_7909() || !class_1799.method_7975((class_1799)test, (class_1799)stack)) continue;
            return true;
        }
        return false;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public void setFilterType(int filterType) {
        this.filterType = filterType;
    }

    public boolean isMatchNbt() {
        return this.matchNbt;
    }

    public void setMatchNbt(boolean matchNbt) {
        this.matchNbt = matchNbt;
    }

    public boolean isMatchMod() {
        return this.matchMod;
    }

    public void setMatchMod(boolean matchMod) {
        this.matchMod = matchMod;
    }

    public void toggleNbtMatch() {
        this.matchNbt = !this.matchNbt;
    }

    public void toggleModMatch() {
        this.matchMod = !this.matchMod;
    }

    public void toggleFilterType() {
        this.filterType = this.filterType == 1 ? 0 : 1;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10569("type", this.filterType);
        tag.method_10569("height", this.height);
        tag.method_10556("nbtMatch", this.matchNbt);
        tag.method_10556("modMatch", this.matchMod);
        return tag;
    }

    public void method_5435(class_1657 player) {
        player.method_17356(class_3417.field_14557, class_3419.field_15248, 1.0f, 1.0f);
    }

    public void method_5432(class_1657 player) {
        player.method_17356(class_3417.field_15226, class_3419.field_15248, 1.0f, 1.0f);
        player.method_17356(class_3417.field_14557, class_3419.field_15248, 1.0f, 1.0f);
    }
}

