/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.particle;

import net.flytre.flytre_lib.common.particle.core.LibParticle;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class CircularParticle
extends LibParticle {
    protected final double radius;
    protected final double degreeRotation;

    public CircularParticle(class_3218 world, double radius) {
        super(world);
        this.radius = radius;
        this.degreeRotation = (int)(360.0 / (4.71238898038469 * radius));
    }

    public CircularParticle(class_3218 world, double radius, double precision) {
        super(world);
        this.radius = radius;
        this.degreeRotation = (int)(360.0 / (2.356194490192345 * precision * radius));
    }

    @Override
    public void draw(class_241 rotation, class_243 position) {
        double i = 0.0;
        double j = 0.0;
        while (i < 360.0) {
            class_243 crt = new class_243(this.radius * Math.cos(j), 0.0, this.radius * Math.sin(j));
            double progress = (360.0 - i) / 360.0;
            if (this.getGradient() == null) {
                this.drawParticle(rotation, position, crt);
            } else {
                this.drawParticle(rotation, position, crt, progress);
            }
            j = (i += this.degreeRotation) * Math.PI / 180.0;
        }
    }
}

