/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.particle.core;

import com.sun.javafx.geom.Vec3f;

public class Color {
    public static Color WHITE = new Color(255, 255, 255);
    public static Color BLACK = new Color(0, 0, 0);
    private final int red;
    private final int green;
    private final int blue;

    public Color() {
        this.green = 0;
        this.blue = 0;
        this.red = 0;
    }

    public Color(int red, int green, int blue) {
        this.red = red;
        this.blue = blue;
        this.green = green;
    }

    public Color(String dustColors) {
        String[] nums = dustColors.split(" ");
        this.red = (int)(Double.parseDouble(nums[0]) * 255.0);
        this.green = (int)(Double.parseDouble(nums[1]) * 255.0);
        this.blue = (int)(Double.parseDouble(nums[2]) * 255.0);
    }

    public static Color random() {
        return new Color((int)(Math.random() * 256.0), (int)(Math.random() * 256.0), (int)(Math.random() * 256.0));
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public Vec3f calcDustValues() {
        return new Vec3f((float)this.red / 255.0f, (float)this.green / 255.0f, (float)this.blue / 255.0f);
    }

    public String toString() {
        return this.red + ", " + this.green + ", " + this.blue;
    }

    public static void main(String[] args) {
        Color helixStart = new Color("0.5216 0.651 0.6118");
        System.out.println(helixStart);
        Color helixEnd = new Color("0.1922 0.2471 0.4784");
        System.out.println(helixEnd);
    }
}

