/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.particle.core;

import net.flytre.flytre_lib.common.particle.core.Color;

public class Gradient {
    private final Color start;
    private final Color end;
    private final boolean polar;

    public Gradient(Color start, Color end, boolean polar) {
        this.start = start;
        this.end = end;
        this.polar = polar;
    }

    public Color getStart() {
        return this.start;
    }

    public Color getEnd() {
        return this.end;
    }

    public Color calculateValue(double progress) {
        progress %= 100.0;
        if (this.polar) {
            progress = progress < 0.5 ? (progress *= 2.0) : 1.0 - (progress - 0.5) * 2.0;
        }
        int red = (int)((double)this.end.getRed() * progress + (double)this.start.getRed() * (1.0 - progress));
        int green = (int)((double)this.end.getGreen() * progress + (double)this.start.getGreen() * (1.0 - progress));
        int blue = (int)((double)this.end.getBlue() * progress + (double)this.start.getBlue() * (1.0 - progress));
        return new Color(red, green, blue);
    }
}

