/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.particle.core;

import com.sun.javafx.geom.Vec3f;
import net.flytre.flytre_lib.common.particle.core.Color;
import net.flytre.flytre_lib.common.particle.core.Gradient;
import net.flytre.flytre_lib.common.particle.core.OffsetRule;
import net.flytre.flytre_lib.common.util.ParticleUtils;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public abstract class LibParticle {
    protected final class_3218 world;
    protected int frame;
    protected Color color;
    protected Gradient gradient;
    protected OffsetRule offsetRule;

    public LibParticle(class_3218 world) {
        this.world = world;
        this.color = new Color(0, 0, 0);
        this.gradient = null;
        this.frame = 0;
    }

    public OffsetRule getOffsetRule() {
        return this.offsetRule;
    }

    public void setOffsetRule(OffsetRule offsetRule) {
        this.offsetRule = offsetRule;
    }

    public Gradient getGradient() {
        return this.gradient;
    }

    public void setGradient(Gradient gradient) {
        this.gradient = gradient;
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int frame) {
        this.frame = frame;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    private class_2394 getParticle(Color color) {
        Vec3f dust = color.calcDustValues();
        return new class_2390(dust.x, dust.y, dust.z, 1.0f);
    }

    protected void drawParticle(class_241 rotation, class_243 position, class_243 caretValues) {
        class_243 pos = ParticleUtils.caretToAbsolute(caretValues, rotation, position);
        this.world.method_14199(this.getParticle(this.color), pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected void drawParticle(class_241 rotation, class_243 position, class_243 caretValues, Color c) {
        class_243 pos = ParticleUtils.caretToAbsolute(caretValues, rotation, position);
        this.world.method_14199(this.getParticle(c), pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
    }

    protected void drawParticle(class_241 rotation, class_243 position, class_243 caretValues, double progress) {
        class_243 pos = ParticleUtils.caretToAbsolute(caretValues, rotation, position);
        this.world.method_14199(this.getParticle(this.gradient.calculateValue(progress)), pos.field_1352, pos.field_1351, pos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public abstract void draw(class_241 var1, class_243 var2);

    public void line(class_243 a, class_243 b) {
        this.line(a, b, -1.0, -1.0);
    }

    public void line(class_243 a, class_243 b, double minProgress, double maxProgress) {
        class_243 deltas = new class_243(Math.max(b.field_1352 - a.field_1352, 0.001), b.field_1351 - a.field_1351, b.field_1350 - a.field_1350);
        double dist = Math.hypot(Math.hypot(deltas.field_1352, deltas.field_1351), deltas.field_1350);
        int points = (int)(dist * 5.0);
        for (double ix = 0.0; ix < Math.abs(deltas.field_1352); ix += Math.abs(deltas.field_1352) / (double)points) {
            class_243 pos = new class_243(deltas.field_1352, deltas.field_1351, deltas.field_1350).method_1021(ix / Math.abs(deltas.field_1352)).method_1031(a.field_1352, a.field_1351, a.field_1350);
            if (minProgress == -1.0 && maxProgress == -1.0) {
                this.drawParticle(new class_241(0.0f, 0.0f), pos, new class_243(0.0, 0.0, 0.0));
                continue;
            }
            double percentDone = ix / Math.abs(deltas.field_1352);
            double gradientPercent = minProgress + percentDone * (maxProgress - minProgress);
            this.drawParticle(new class_241(0.0f, 0.0f), pos, new class_243(0.0, 0.0, 0.0), gradientPercent);
        }
    }
}

