/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.flytre.flytre_lib.common.recipe.TaggedItem;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class OutputProvider {
    public static final OutputProvider EMPTY = new OutputProvider(class_1799.field_8037, 1.0);
    private final boolean isTag;
    private final class_1799 stack;
    private final TaggedItem taggedItem;
    private final double chance;

    public OutputProvider(class_1799 stack, double chance) {
        this.isTag = false;
        this.stack = stack;
        this.taggedItem = null;
        this.chance = chance;
    }

    public OutputProvider(TaggedItem item, double chance) {
        this.isTag = true;
        this.stack = null;
        this.taggedItem = item;
        this.chance = chance;
    }

    public class_1799 getStack() {
        return this.isTag ? this.taggedItem.getItemStack() : this.stack.method_7972();
    }

    public static OutputProvider fromJson(JsonElement jsonElement) {
        JsonObject json = null;
        if (jsonElement.isJsonObject()) {
            json = (JsonObject)jsonElement;
        }
        if (class_3518.method_15289((JsonObject)json, (String)"tag")) {
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            int i = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
            double chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
            return new OutputProvider(new TaggedItem(id, i), chance);
        }
        if (jsonElement.isJsonPrimitive()) {
            String id = jsonElement.getAsString();
            class_2960 identifier2 = new class_2960(id);
            class_1799 itemStack = class_2378.field_11142.method_17966(identifier2).map(class_1799::new).orElse(class_1799.field_8037);
            return new OutputProvider(itemStack, 1.0);
        }
        String string = class_3518.method_15265((JsonObject)json, (String)"item");
        class_1792 item = class_2378.field_11142.method_17966(new class_2960(string)).orElse(class_1802.field_8162);
        int i = class_3518.method_15282((JsonObject)json, (String)"count", (int)1);
        double chance = class_3518.method_15277((JsonObject)json, (String)"chance", (float)1.0f);
        return new OutputProvider(new class_1799((class_1935)item, i), chance);
    }

    public double getChance() {
        return this.chance;
    }

    public void toPacket(class_2540 packet) {
        packet.writeBoolean(this.isTag);
        if (this.isTag) {
            packet.method_10812(this.taggedItem.getPath());
            packet.writeInt(this.taggedItem.getQty());
        } else {
            packet.method_10793(this.stack);
        }
        packet.writeDouble(this.chance);
    }

    public static OutputProvider fromPacket(class_2540 buf) {
        boolean isTag = buf.readBoolean();
        if (isTag) {
            return new OutputProvider(new TaggedItem(buf.method_10810(), buf.readInt()), buf.readDouble());
        }
        return new OutputProvider(buf.method_10819(), buf.readDouble());
    }
}

