/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.flytre.flytre_lib.common.recipe.OutputProvider;
import net.flytre.flytre_lib.common.recipe.QuantifiedIngredient;
import net.flytre.flytre_lib.common.util.InventoryUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3494;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5323;
import org.jetbrains.annotations.Nullable;

public class RecipeUtils {
    private static final HashMap<class_1792, List<class_3955>> cache = new HashMap();

    public static void clearCache() {
        if (cache != null) {
            cache.clear();
        }
    }

    public static class_1856 fromJson(@Nullable JsonElement json) {
        return json == null || RecipeUtils.isIngredientInvalid(json) ? class_1856.field_9017 : class_1856.method_8102((JsonElement)json);
    }

    public static boolean isIngredientInvalid(@Nullable JsonElement json) {
        if (json != null && !json.isJsonNull()) {
            if (json.isJsonObject()) {
                return RecipeUtils.nullCheck(json.getAsJsonObject());
            }
            if (json.isJsonArray()) {
                JsonArray jsonArray = json.getAsJsonArray();
                if (jsonArray.size() == 0) {
                    return true;
                }
                return StreamSupport.stream(jsonArray.spliterator(), false).anyMatch(jsonElement -> RecipeUtils.nullCheck(class_3518.method_15295((JsonElement)jsonElement, (String)"item")));
            }
            return true;
        }
        return true;
    }

    private static boolean nullCheck(JsonObject json) {
        if (json.has("item") && json.has("tag")) {
            return true;
        }
        if (json.has("item")) {
            class_2960 id = new class_2960(class_3518.method_15265((JsonObject)json, (String)"item"));
            return !class_2378.field_11142.method_10235().contains(id);
        }
        if (json.has("tag")) {
            class_2960 identifier2 = new class_2960(class_3518.method_15265((JsonObject)json, (String)"tag"));
            class_3494 tag = class_5323.method_29223().method_30218().method_30210(identifier2);
            return tag == null;
        }
        return true;
    }

    public static void craftOutput(class_1263 inv, int lower, int upper, OutputProvider[] providers) {
        HashSet<Integer> checked = new HashSet<Integer>();
        block0: for (OutputProvider output : providers) {
            int i;
            boolean matched = false;
            for (i = lower; i < upper; ++i) {
                if (checked.contains(i) || !InventoryUtils.canUnifyStacks(output.getStack(), inv.method_5438(i))) continue;
                matched = true;
                checked.add(i);
                inv.method_5438(i).method_7933(output.getStack().method_7947());
                break;
            }
            if (matched) continue;
            for (i = lower; i < upper; ++i) {
                if (!inv.method_5438(i).method_7960()) continue;
                inv.method_5447(i, output.getStack());
                continue block0;
            }
        }
    }

    public static boolean matches(class_1263 inv, int lower, int upper, OutputProvider[] outputProviders) {
        int blanks = 0;
        for (int i = lower; i < upper; ++i) {
            if (!inv.method_5438(i).method_7960()) continue;
            ++blanks;
        }
        HashSet<Integer> checked = new HashSet<Integer>();
        for (OutputProvider output : outputProviders) {
            boolean matched = false;
            for (int i = lower; i < upper; ++i) {
                if (checked.contains(i) || !InventoryUtils.canUnifyStacks(output.getStack(), inv.method_5438(i))) continue;
                matched = true;
                checked.add(i);
                break;
            }
            if (matched) continue;
            if (blanks == 0) {
                return false;
            }
            --blanks;
        }
        return true;
    }

    public static boolean craftingInputMatch(class_3955 recipe, class_1263 inv, int lower, int upper) {
        class_2371 ingredients = recipe.method_8117();
        List actual = ingredients.stream().filter(i -> !i.method_8103()).collect(Collectors.toList());
        ArrayList<class_1799> copy = new ArrayList<class_1799>();
        for (int i2 = lower; i2 < upper; ++i2) {
            copy.add(i2, inv.method_5438(i2).method_7972());
        }
        for (class_1856 ingredient : actual) {
            boolean matched = false;
            for (int i3 = lower; i3 < upper; ++i3) {
                if (!ingredient.method_8093((class_1799)copy.get(i3))) continue;
                matched = true;
                ((class_1799)copy.get(i3)).method_7934(1);
                break;
            }
            if (matched) continue;
            return false;
        }
        return true;
    }

    public static void actuallyCraft(class_3955 recipe, class_1263 inv, int lower, int upper) {
        class_2371 ingredients = recipe.method_8117();
        List actual = ingredients.stream().filter(i -> !i.method_8103()).collect(Collectors.toList());
        block0: for (class_1856 ingredient : actual) {
            for (int i2 = lower; i2 < upper; ++i2) {
                if (!ingredient.method_8093(inv.method_5438(i2))) continue;
                class_1799 stack = inv.method_5438(i2);
                if (stack.method_7947() == 1 && stack.method_7909().method_7857()) {
                    inv.method_5447(i2, new class_1799((class_1935)stack.method_7909().method_7858(), 1));
                    continue block0;
                }
                stack.method_7934(1);
                continue block0;
            }
        }
    }

    public static List<class_3955> craftingRecipesWithOutput(class_1792 item, class_1937 world) {
        if (cache.containsKey(item)) {
            return cache.get(item);
        }
        List<class_3955> recipes = world.method_8433().method_30027(class_3956.field_17545).stream().filter(i -> !(i instanceof class_1852)).filter(i -> i.method_8110().method_7909() == item).collect(Collectors.toList());
        cache.put(item, recipes);
        return recipes;
    }

    @Nullable
    public static class_3955 getFirstCraftingMatch(class_1792 item, class_1263 inv, class_1937 world, int lower, int upper) {
        List<class_3955> outputs = RecipeUtils.craftingRecipesWithOutput(item, world);
        Optional<class_3955> result = outputs.stream().filter(i -> RecipeUtils.craftingInputMatch(i, inv, lower, upper)).findFirst();
        return result.orElse(null);
    }

    public static OutputProvider[] getOutputProviders(JsonObject json, String pluralKey, String singularKey) {
        OutputProvider[] result;
        if (class_3518.method_15264((JsonObject)json, (String)pluralKey)) {
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)pluralKey);
            result = new OutputProvider[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                result[i] = OutputProvider.fromJson(array.get(i));
            }
        } else {
            result = new OutputProvider[]{OutputProvider.fromJson(json.get(singularKey))};
        }
        return result;
    }

    public static QuantifiedIngredient[] getQuantifiedIngredients(JsonObject json, String pluralKey, String singularKey) {
        return RecipeUtils.getQuantifiedIngredients(json, pluralKey, singularKey, false);
    }

    public static QuantifiedIngredient[] getQuantifiedIngredients(JsonObject json, String pluralKey, String singularKey, boolean opt) {
        QuantifiedIngredient[] ingredients = new QuantifiedIngredient[]{};
        if (class_3518.method_15264((JsonObject)json, (String)pluralKey)) {
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)pluralKey);
            ingredients = new QuantifiedIngredient[array.size()];
            for (int i = 0; i < array.size(); ++i) {
                ingredients[i] = QuantifiedIngredient.fromJson(array.get(i));
            }
        } else if (class_3518.method_15294((JsonObject)json, (String)singularKey) || !opt) {
            ingredients = new QuantifiedIngredient[]{QuantifiedIngredient.fromJson(json.get(singularKey))};
        }
        return ingredients;
    }
}

