/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2281;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_3954;
import org.jetbrains.annotations.Nullable;

public class InventoryUtils {
    public static boolean isInventoryFull(class_1263 inv, class_2350 direction) {
        return InventoryUtils.getAvailableSlots(inv, direction).allMatch(i -> {
            class_1799 itemStack = inv.method_5438(i);
            return itemStack.method_7947() >= itemStack.method_7914();
        });
    }

    public static IntStream getAvailableSlots(class_1263 inventory, class_2350 side) {
        return inventory instanceof class_1278 ? IntStream.of(((class_1278)inventory).method_5494(side)) : IntStream.range(0, inventory.method_5439());
    }

    public static boolean canMergeItems(class_1799 first, class_1799 second) {
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7919() != second.method_7919()) {
            return false;
        }
        if (first.method_7947() > first.method_7914()) {
            return false;
        }
        return class_1799.method_7975((class_1799)first, (class_1799)second);
    }

    public static boolean canUnifyStacks(class_1799 first, class_1799 second) {
        return InventoryUtils.canMergeItems(first, second) && first.method_7947() + second.method_7947() <= first.method_7914();
    }

    public static boolean canInsert(class_1263 inventory, class_1799 stack, int slot, @Nullable class_2350 side) {
        if (!inventory.method_5437(slot, stack)) {
            return false;
        }
        return !(inventory instanceof class_1278) || ((class_1278)inventory).method_5492(slot, stack, side);
    }

    public static boolean canExtract(class_1263 inv, class_1799 stack, int slot, class_2350 facing) {
        return !(inv instanceof class_1278) || ((class_1278)inv).method_5493(slot, stack, facing);
    }

    public static boolean isInventoryEmpty(class_1263 inv, class_2350 facing) {
        return InventoryUtils.getAvailableSlots(inv, facing).allMatch(i -> inv.method_5438(i).method_7960());
    }

    @Nullable
    public static class_1263 getInventoryAt(class_1937 world, class_2338 blockPos) {
        return InventoryUtils.getInventoryAt(world, (double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5);
    }

    @Nullable
    public static class_1263 getInventoryAt(class_1937 world, double x, double y, double z) {
        List list;
        class_2586 blockEntity;
        class_1278 inventory = null;
        class_2338 blockPos = new class_2338(x, y, z);
        class_2680 blockState = world.method_8320(blockPos);
        class_2248 block = blockState.method_26204();
        if (block instanceof class_3954) {
            inventory = ((class_3954)block).method_17680(blockState, (class_1936)world, blockPos);
        } else if (block.method_26161() && (blockEntity = world.method_8321(blockPos)) instanceof class_1263 && (inventory = (class_1263)blockEntity) instanceof class_2595 && block instanceof class_2281) {
            inventory = class_2281.method_17458((class_2281)((class_2281)block), (class_2680)blockState, (class_1937)world, (class_2338)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.method_8333(null, new class_238(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), class_1301.field_6152)).isEmpty()) {
            inventory = (class_1263)list.get(world.field_9229.nextInt(list.size()));
        }
        return inventory;
    }

    public static List<class_1799> getCombinedInventory(class_1661 inv) {
        ArrayList<class_1799> result = new ArrayList<class_1799>((Collection<class_1799>)inv.field_7547);
        result.addAll((Collection<class_1799>)inv.field_7544);
        result.addAll((Collection<class_1799>)inv.field_7548);
        return result;
    }

    public static Map<class_1792, Integer> countInventoryContents(class_1263 inventory) {
        HashMap<class_1792, Integer> result = new HashMap<class_1792, Integer>();
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (result.containsKey(stack.method_7909())) {
                result.put(stack.method_7909(), stack.method_7947() + (Integer)result.get(stack.method_7909()));
                continue;
            }
            result.put(stack.method_7909(), stack.method_7947());
        }
        return result;
    }

    public static class_1799 putStackInInventory(class_1799 stack, class_1263 inventory) {
        return InventoryUtils.putStackInInventory(stack, inventory, 0, inventory.method_5439());
    }

    public static class_1799 putStackInInventory(class_1799 stack, class_1263 inventory, int minSlot, int maxSlot) {
        for (int i = minSlot; i < maxSlot && !stack.method_7960(); ++i) {
            stack = InventoryUtils.mergeStackIntoSlot(stack, inventory, i);
        }
        return stack;
    }

    public static class_1799 mergeStackIntoSlot(class_1799 stack, class_1263 inventory, int slot) {
        class_1799 itemStack = inventory.method_5438(slot);
        boolean bl = false;
        if (itemStack.method_7960()) {
            inventory.method_5447(slot, stack);
            stack = class_1799.field_8037;
            bl = true;
        } else if (InventoryUtils.canMergeItems(itemStack, stack)) {
            int i = stack.method_7914() - itemStack.method_7947();
            int j = Math.min(stack.method_7947(), i);
            stack.method_7934(j);
            itemStack.method_7933(j);
            boolean bl2 = bl = j > 0;
        }
        if (bl) {
            inventory.method_5431();
        }
        return stack;
    }

    @Nullable
    public static class_1799 getHoldingStack(class_1309 entity, Predicate<class_1799> condition) {
        class_1799 stack = entity.method_6079();
        if (!condition.test(stack)) {
            stack = entity.method_6047();
        }
        if (!condition.test(stack)) {
            return null;
        }
        return stack;
    }

    public static class_2487 toTag(class_2487 tag, class_2371<class_1799> stacks, String key) {
        class_2487 temp = new class_2487();
        class_1262.method_5426((class_2487)temp, stacks);
        tag.method_10566(key, temp.method_10580("Items"));
        return tag;
    }

    public static class_2487 fromTag(class_2487 tag, class_2371<class_1799> stacks, String key) {
        class_2487 temp = new class_2487();
        temp.method_10566("Items", tag.method_10580(key));
        class_1262.method_5429((class_2487)temp, stacks);
        return tag;
    }
}

