/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LazilyParsedNumber;
import java.util.Map;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2503;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class JsonNbtConverter {
    public static class_2520 toNbt(JsonElement json) {
        if (json instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)json;
            if (primitive.isBoolean()) {
                return class_2481.method_23234((boolean)primitive.getAsBoolean());
            }
            if (primitive.isNumber()) {
                Number number = primitive.getAsNumber();
                if (number instanceof Byte) {
                    return class_2481.method_23233((byte)number.byteValue());
                }
                if (number instanceof Short) {
                    return class_2516.method_23254((short)number.shortValue());
                }
                if (number instanceof Integer) {
                    return class_2497.method_23247((int)number.intValue());
                }
                if (number instanceof Long) {
                    return class_2503.method_23251((long)number.longValue());
                }
                if (number instanceof Float) {
                    return class_2494.method_23244((float)number.floatValue());
                }
                if (number instanceof Double) {
                    return class_2489.method_23241((double)number.doubleValue());
                }
                if (number instanceof LazilyParsedNumber) {
                    double val = number.doubleValue();
                    if (Math.abs(val - Math.floor(val)) < 0.001) {
                        return class_2497.method_23247((int)((int)Math.round(val)));
                    }
                    return class_2489.method_23241((double)val);
                }
            } else if (primitive.isString()) {
                return class_2519.method_23256((String)primitive.getAsString());
            }
        } else {
            if (json instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)json;
                class_2499 list = new class_2499();
                for (JsonElement element : jsonArray) {
                    list.add((Object)JsonNbtConverter.toNbt(element));
                }
                return list;
            }
            if (json instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)json;
                class_2487 compound = new class_2487();
                for (Map.Entry jsonEntry : jsonObject.entrySet()) {
                    compound.method_10566((String)jsonEntry.getKey(), JsonNbtConverter.toNbt((JsonElement)jsonEntry.getValue()));
                }
                return compound;
            }
            if (json instanceof JsonNull) {
                throw new AssertionError((Object)"Null elements not supported.");
            }
        }
        throw new AssertionError((Object)"JSON to NBT f*cked up.");
    }

    public static JsonElement toJson(class_2520 nbtElement) {
        return JsonNbtConverter.toJson(nbtElement, ConversionMode.RAW);
    }

    public static JsonElement toJson(class_2520 element, ConversionMode mode) {
        if (element instanceof class_2514) {
            class_2514 nbtNumber = (class_2514)element;
            switch (mode) {
                case JSON: {
                    if (nbtNumber instanceof class_2481) {
                        class_2481 nbtByte = (class_2481)nbtNumber;
                        byte value = nbtByte.method_10698();
                        switch (value) {
                            case 0: {
                                return new JsonPrimitive(Boolean.valueOf(false));
                            }
                            case 1: {
                                return new JsonPrimitive(Boolean.valueOf(true));
                            }
                        }
                    }
                }
                case RAW: {
                    return new JsonPrimitive(nbtNumber.method_10702());
                }
            }
        } else {
            if (element instanceof class_2519) {
                return new JsonPrimitive(element.method_10714());
            }
            if (element instanceof class_2499) {
                class_2499 list = (class_2499)element;
                JsonArray jsonArray = new JsonArray();
                for (class_2520 tag : list) {
                    jsonArray.add(JsonNbtConverter.toJson(tag, mode));
                }
                return jsonArray;
            }
            if (element instanceof class_2487) {
                class_2487 compound = (class_2487)element;
                JsonObject jsonObject = new JsonObject();
                for (String key : compound.method_10541()) {
                    jsonObject.add(key, JsonNbtConverter.toJson(compound.method_10580(key), mode));
                }
                return jsonObject;
            }
            if (element instanceof class_2491) {
                throw new AssertionError((Object)"Should not encounter end tag");
            }
        }
        throw new UnsupportedOperationException("Unsupported nbt tag type");
    }

    public static enum ConversionMode {
        RAW,
        JSON;

    }
}

