/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.class_2540;

public class PacketUtils {
    public static <T> void toPacket(class_2540 buf, List<T> list, BiConsumer<T, class_2540> func) {
        buf.writeInt(list.size());
        for (T element : list) {
            func.accept(element, buf);
        }
    }

    public static <T> void toPacket(class_2540 buf, Set<T> set, BiConsumer<T, class_2540> func) {
        buf.writeInt(set.size());
        for (T element : set) {
            func.accept(element, buf);
        }
    }

    public static <T, K> void toPacket(class_2540 buf, Map<T, K> map, BiConsumer<T, class_2540> keyToPacket, BiConsumer<K, class_2540> valToPacket) {
        buf.writeInt(map.keySet().size());
        for (T key : map.keySet()) {
            keyToPacket.accept(key, buf);
            valToPacket.accept(map.get(key), buf);
        }
    }

    public static <T> List<T> listFromPacket(class_2540 buf, Function<class_2540, T> func) {
        int size = buf.readInt();
        ArrayList<T> result = new ArrayList<T>();
        for (int i = 0; i < size; ++i) {
            result.add(func.apply(buf));
        }
        return result;
    }

    public static <T> Set<T> setFromPacket(class_2540 buf, Function<class_2540, T> func) {
        int size = buf.readInt();
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < size; ++i) {
            result.add(func.apply(buf));
        }
        return result;
    }

    public static <T, K> Map<T, K> mapFromPacket(class_2540 buf, Function<class_2540, T> packetToKey, Function<class_2540, K> packetToVal) {
        HashMap<T, K> result = new HashMap<T, K>();
        int hashSize = buf.readInt();
        for (int i = 0; i < hashSize; ++i) {
            T key = packetToKey.apply(buf);
            K value = packetToVal.apply(buf);
            result.put(key, value);
        }
        return result;
    }
}

