/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.flytre_lib.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigHandler<T> {
    private final Gson gson;
    private final T assumed;
    private final String name;
    private T config;

    public ConfigHandler(T assumed, String name) {
        this(assumed, name, new GsonBuilder().setPrettyPrinting().create());
    }

    public ConfigHandler(T assumed, String name, Gson gson) {
        this.assumed = assumed;
        this.name = name;
        this.gson = gson;
    }

    public void save(T config) {
        Path location = FabricLoader.getInstance().getConfigDir();
        Path path = Paths.get(location.toString(), this.name + ".json");
        try {
            FileWriter writer = new FileWriter(path.toFile());
            this.gson.toJson(config, (Appendable)writer);
            ((Writer)writer).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void handle() {
        Path location = FabricLoader.getInstance().getConfigDir();
        File config = location.toFile();
        File configFile = null;
        for (File file : config.listFiles()) {
            if (!file.getName().equals(this.name + ".json")) continue;
            configFile = file;
            break;
        }
        if (configFile == null) {
            this.save(this.assumed);
            this.config = this.assumed;
        } else {
            try (FileReader reader = new FileReader(configFile);){
                this.config = this.gson.fromJson((Reader)reader, this.assumed.getClass());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public T getAssumed() {
        return this.assumed;
    }

    public T getConfig() {
        return this.config;
    }
}

