/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.salutem;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import java.util.Stack;
import java.util.stream.StreamSupport;
import net.flytre.salutem.Salutem;
import net.flytre.salutem.api.SalutemConfig;
import net.flytre.salutem.api.UIStyle;
import net.flytre.salutem.ui.DefaultUIStyle;
import net.flytre.salutem.util.RenderUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class HealthBarRenderer {
    public static void render(class_4587 matrices, float partialTicks, class_4184 camera, class_1159 projection, class_4604 capturedFrustum) {
        class_1297 cameraEntity;
        class_310 mc = class_310.method_1551();
        SalutemConfig config = (SalutemConfig)Salutem.CONFIG.getConfig();
        if (mc.field_1687 == null || !config.canRenderInF1() && !class_310.method_1498() || !config.canDraw()) {
            return;
        }
        Object object = cameraEntity = camera.method_19331() != null ? camera.method_19331() : mc.field_1724;
        assert (cameraEntity != null) : "Camera Entity must not be null!";
        if (config.showingOnlyFocused()) {
            class_1297 focused = HealthBarRenderer.getEntityLookedAt(cameraEntity);
            if (focused instanceof class_1309 && focused.method_5805()) {
                HealthBarRenderer.renderHealthBar((class_1309)focused, matrices, partialTicks, camera, cameraEntity);
            }
        } else {
            class_4604 frustum;
            class_243 cameraPos = camera.method_19326();
            if (capturedFrustum != null) {
                frustum = capturedFrustum;
            } else {
                frustum = new class_4604(matrices.method_23760().method_23761(), projection);
                frustum.method_23088(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215());
            }
            StreamSupport.stream(mc.field_1687.method_18112().spliterator(), false).filter(entity -> entity instanceof class_1309 && entity != cameraEntity && entity.method_5805() && entity.method_5736().isEmpty() && entity.method_5727(cameraPos.method_10216(), cameraPos.method_10214(), cameraPos.method_10215()) && (entity.field_5985 || frustum.method_23093(entity.method_5829()))).map(class_1309.class::cast).forEach(entity -> HealthBarRenderer.renderHealthBar(entity, matrices, partialTicks, camera, cameraEntity));
        }
    }

    private static class_1297 getEntityLookedAt(class_1297 e) {
        class_1297 foundEntity = null;
        double finalDistance = 32.0;
        double distance = 32.0;
        class_239 pos = HealthBarRenderer.raycast(e, 32.0);
        class_243 positionVector = e.method_19538();
        if (e instanceof class_1657) {
            positionVector = positionVector.method_1031(0.0, (double)e.method_18381(e.method_18376()), 0.0);
        }
        if (pos != null) {
            distance = pos.method_17784().method_1022(positionVector);
        }
        class_243 lookVector = e.method_5720();
        class_243 reachVector = positionVector.method_1031(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0);
        class_1297 lookedEntity = null;
        List entitiesInBoundingBox = e.method_5770().method_8335(e, e.method_5829().method_1012(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0).method_1014(1.0));
        double minDistance = distance;
        for (class_1297 entity : entitiesInBoundingBox) {
            if (entity.method_5863()) {
                double distanceToEntity;
                class_238 collisionBox = entity.method_5830();
                Optional interceptPosition = collisionBox.method_992(positionVector, reachVector);
                if (collisionBox.method_1006(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.method_1022((class_243)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance) && pos != null) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static void renderHealthBar(class_1309 passedEntity, class_4587 matrices, float partialTicks, class_4184 camera, class_1297 viewPoint) {
        Preconditions.checkNotNull((Object)passedEntity, (Object)"tried to render health bar for null entity");
        SalutemConfig config = (SalutemConfig)Salutem.CONFIG.getConfig();
        UIStyle style = DefaultUIStyle.getInstance();
        class_310 mc = class_310.method_1551();
        Stack<class_1309> passengerStack = new Stack<class_1309>();
        class_1309 entity = passedEntity;
        passengerStack.push(entity);
        while (entity.method_5642() instanceof class_1309) {
            entity = (class_1309)entity.method_5642();
            passengerStack.push(entity);
        }
        matrices.method_22903();
        while (!passengerStack.isEmpty()) {
            float distance;
            entity = (class_1309)passengerStack.pop();
            if (!entity.method_5805()) continue;
            String idString = String.valueOf(class_2378.field_11145.method_10221((Object)entity.method_5864()));
            boolean boss = config.getBosses().contains(idString);
            if (config.getBlacklist().contains(idString) || (distance = passedEntity.method_5739(viewPoint)) > (float)config.getMaxDistance() || !passedEntity.method_6057(viewPoint) || entity.method_5767() || boss && !config.canShowOnBosses() || !config.canShowOnPlayers() && entity instanceof class_1657 || entity.method_6063() <= 0.0f) continue;
            double x = passedEntity.field_6014 + (passedEntity.method_23317() - passedEntity.field_6014) * (double)partialTicks;
            double y = passedEntity.field_6036 + (passedEntity.method_23318() - passedEntity.field_6036) * (double)partialTicks;
            double z = passedEntity.field_5969 + (passedEntity.method_23321() - passedEntity.field_5969) * (double)partialTicks;
            class_898 renderManager = class_310.method_1551().method_1561();
            matrices.method_22903();
            matrices.method_22904(x - renderManager.field_4686.method_19326().field_1352, y - renderManager.field_4686.method_19326().field_1351 + (double)passedEntity.method_17682() + config.getHeightAbove(), z - renderManager.field_4686.method_19326().field_1350);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.disableLighting();
            class_4597.class_4598 immediate = mc.method_22940().method_23000();
            class_1799 icon = RenderUtil.getIcon(entity, boss);
            int light = 0xF000F0;
            if (boss) {
                style.renderBossEntity(matrices, immediate, camera, config, entity, 0xF000F0, icon);
            } else {
                style.renderEntity(matrices, immediate, camera, config, entity, 0xF000F0, icon);
            }
            matrices.method_22909();
            matrices.method_22904(0.0, (double)(-(config.getBackgroundHeight() + config.getBarHeight() + config.getBackgroundPadding())), 0.0);
        }
        matrices.method_22909();
    }

    @Nullable
    private static class_239 raycast(class_1297 entity, double len) {
        class_243 look;
        class_243 vec = new class_243(entity.method_23317(), entity.method_23318(), entity.method_23321());
        if (entity instanceof class_1657) {
            vec = vec.method_1019(new class_243(0.0, (double)entity.method_18381(entity.method_18376()), 0.0));
        }
        if ((look = entity.method_5720()) == null) {
            return null;
        }
        return HealthBarRenderer.raycast(entity, vec, look, len);
    }

    private static class_239 raycast(class_1297 entity, class_243 origin, class_243 ray, double len) {
        class_243 next = origin.method_1019(ray.method_1029().method_1021(len));
        return entity.method_5770().method_17742(new class_3959(origin, next, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity));
    }
}

