/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.salutem.config;

import com.google.common.collect.Sets;
import com.google.gson.annotations.SerializedName;
import java.util.Set;
import net.flytre.salutem.api.SalutemConfig;

public class SalutemConfigImpl
implements SalutemConfig {
    private String[] blacklist = new String[]{"minecraft:armor_stand", "minecraft:bee", "minecraft:cod", "minecraft:pufferfish", "minecraft:salmon", "minecraft:shulker", "minecraft:tropical_fish", "illuminations:firefly"};
    private String[] bosses = new String[]{"minecraft:ender_dragon", "minecraft:wither"};
    private boolean draw = true;
    @SerializedName(value="max_distance")
    private int maxDistance = 24;
    @SerializedName(value="render_in_f1")
    private boolean renderInF1 = false;
    @SerializedName(value="health_bar_scale")
    private float healthBarScale = 1.0f;
    @SerializedName(value="height_above")
    private double heightAbove = 0.6;
    @SerializedName(value="draw_background")
    private boolean drawBackground = true;
    @SerializedName(value="background_padding")
    private int backgroundPadding = 2;
    @SerializedName(value="background_height")
    private int backgroundHeight = 6;
    @SerializedName(value="bar_height")
    private int barHeight = 4;
    @SerializedName(value="plate_size")
    private int plateSize = 25;
    @SerializedName(value="plate_size_boss")
    private int plateSizeBoss = 50;
    @SerializedName(value="show_attributes")
    private boolean showAttributes = true;
    @SerializedName(value="show_armor")
    private boolean showArmor = true;
    @SerializedName(value="group_armor")
    private boolean groupArmor = true;
    @SerializedName(value="color_by_type")
    private boolean colorByType = false;
    @SerializedName(value="hp_text_height")
    private int hpTextHeight = 14;
    @SerializedName(value="show_max_hp")
    private boolean showMaxHP = true;
    @SerializedName(value="show_current_hp")
    private boolean showCurrentHP = true;
    @SerializedName(value="show_percentage")
    private boolean showPercentage = true;
    @SerializedName(value="show_on_players")
    private boolean showOnPlayers = true;
    @SerializedName(value="show_on_bosses")
    private boolean showOnBosses = true;
    @SerializedName(value="show_only_focused")
    private boolean showOnlyFocused = false;
    @SerializedName(value="enable_debug_info")
    private boolean enableDebugInfo = false;
    private transient Set<String> bossCache;
    private transient Set<String> blacklistCache;

    @Override
    public boolean canDraw() {
        return this.draw;
    }

    @Override
    public int getMaxDistance() {
        return this.maxDistance;
    }

    @Override
    public boolean canRenderInF1() {
        return this.renderInF1;
    }

    @Override
    public float getHealthBarScale() {
        return this.healthBarScale;
    }

    @Override
    public double getHeightAbove() {
        return this.heightAbove;
    }

    @Override
    public boolean drawsBackground() {
        return this.drawBackground;
    }

    @Override
    public int getBackgroundPadding() {
        return this.backgroundPadding;
    }

    @Override
    public int getBackgroundHeight() {
        return this.backgroundHeight;
    }

    @Override
    public int getBarHeight() {
        return this.barHeight;
    }

    @Override
    public int getPlateSize() {
        return this.plateSize;
    }

    @Override
    public int getPlateSizeBoss() {
        return this.plateSizeBoss;
    }

    @Override
    public boolean canShowAttributes() {
        return this.showAttributes;
    }

    @Override
    public boolean canShowArmor() {
        return this.showArmor;
    }

    @Override
    public boolean canShowGroupArmor() {
        return this.groupArmor;
    }

    @Override
    public boolean colorByType() {
        return this.colorByType;
    }

    @Override
    public int getHpTextHeight() {
        return this.hpTextHeight;
    }

    @Override
    public boolean canShowMaxHP() {
        return this.showMaxHP;
    }

    @Override
    public boolean showCurrentHP() {
        return this.showCurrentHP;
    }

    @Override
    public boolean canShowPercentage() {
        return this.showPercentage;
    }

    @Override
    public boolean canShowOnPlayers() {
        return this.showOnPlayers;
    }

    @Override
    public boolean canShowOnBosses() {
        return this.showOnBosses;
    }

    @Override
    public boolean showingOnlyFocused() {
        return this.showOnlyFocused;
    }

    @Override
    public boolean isDebugInfoEnabled() {
        return this.enableDebugInfo;
    }

    @Override
    public Set<String> getBlacklist() {
        if (this.blacklistCache == null) {
            this.blacklistCache = Sets.newHashSet((Object[])this.blacklist);
        }
        return this.blacklistCache;
    }

    @Override
    public Set<String> getBosses() {
        if (this.bossCache == null) {
            this.bossCache = Sets.newHashSet((Object[])this.bosses);
        }
        return this.bossCache;
    }

    public void toggleDraw() {
        this.draw = !this.draw;
    }
}

