/*
 * Decompiled with CFR 0.152.
 */
package net.flytre.salutem.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.flytre.salutem.api.SalutemConfig;
import net.flytre.salutem.api.UIStyle;
import net.flytre.salutem.util.RenderUtil;
import net.flytre.salutem.util.SalutemRenderPhase;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class DefaultUIStyle
implements UIStyle {
    private static final UIStyle INSTANCE = new DefaultUIStyle();
    private static final float SCALE_MULTIPLIER = 0.026666673f;

    public static UIStyle getInstance() {
        return INSTANCE;
    }

    protected void render(class_4587 matrices, class_4597.class_4598 immediate, class_4184 camera, SalutemConfig config, class_1309 entity, int light, class_1799 icon, boolean boss) {
        int armor;
        RenderSystem.enableBlend();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_310 mc = class_310.method_1551();
        class_1158 rotation = camera.method_23767().method_23695();
        rotation.method_22872(-1.0f);
        matrices.method_22907(rotation);
        float scale = 0.026666673f * config.getHealthBarScale();
        matrices.method_22905(-scale, -scale, scale);
        float health = class_3532.method_15363((float)entity.method_6032(), (float)0.0f, (float)entity.method_6063());
        float percent = health / entity.method_6063() * 100.0f;
        float size = boss ? (float)config.getPlateSizeBoss() : (float)config.getPlateSize();
        float textScale = 0.5f;
        String name = (entity.method_16914() ? ((class_5250)entity.method_5797()).method_27692(class_124.field_1056) : entity.method_5476()).getString();
        float namel = (float)mc.field_1772.method_1727(name) * textScale;
        if (namel + 20.0f > size * 2.0f) {
            size = namel / 2.0f + 10.0f;
        }
        float healthSize = size * (health / entity.method_6063());
        class_4587.class_4665 entry = matrices.method_23760();
        class_1159 modelViewMatrix = entry.method_23761();
        class_1160 normal = new class_1160(0.0f, 1.0f, 0.0f);
        normal.method_23215(entry.method_23762());
        class_4588 buffer = immediate.getBuffer(SalutemRenderPhase.getHealthBarType(SalutemRenderPhase.HEALTH_BAR_TEXTURE));
        float padding = config.getBackgroundPadding();
        int bgHeight = config.getBackgroundHeight();
        int barHeight = config.getBarHeight();
        if (config.drawsBackground()) {
            buffer.method_22918(modelViewMatrix, -size - padding, (float)(-bgHeight), 0.01f).method_22913(0.0f, 0.0f).method_1336(0, 0, 0, 64).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, -size - padding, (float)barHeight + padding, 0.01f).method_22913(0.0f, 0.5f).method_1336(0, 0, 0, 64).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, size + padding, (float)barHeight + padding, 0.01f).method_22913(1.0f, 0.5f).method_1336(0, 0, 0, 64).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, size + padding, (float)(-bgHeight), 0.01f).method_22913(1.0f, 0.0f).method_1336(0, 0, 0, 64).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        }
        int argb = RenderUtil.getColor(entity, config.colorByType(), boss);
        int r = RenderUtil.getRed(argb);
        int g = RenderUtil.getGreen(argb);
        int b = RenderUtil.getBlue(argb);
        buffer.method_22918(modelViewMatrix, -size, 0.0f, 0.001f).method_22913(0.0f, 0.75f).method_1336(r, g, b, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        buffer.method_22918(modelViewMatrix, -size, (float)barHeight, 0.001f).method_22913(0.0f, 1.0f).method_1336(r, g, b, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        buffer.method_22918(modelViewMatrix, healthSize * 2.0f - size, (float)barHeight, 0.001f).method_22913(1.0f, 1.0f).method_1336(r, g, b, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        buffer.method_22918(modelViewMatrix, healthSize * 2.0f - size, 0.0f, 0.001f).method_22913(1.0f, 0.75f).method_1336(r, g, b, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        if (healthSize < size) {
            buffer.method_22918(modelViewMatrix, -size + healthSize * 2.0f, 0.0f, 0.001f).method_22913(0.0f, 0.5f).method_1336(0, 0, 0, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, -size + healthSize * 2.0f, (float)barHeight, 0.001f).method_22913(0.0f, 0.75f).method_1336(0, 0, 0, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, size, (float)barHeight, 0.001f).method_22913(1.0f, 0.75f).method_1336(0, 0, 0, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            buffer.method_22918(modelViewMatrix, size, 0.0f, 0.001f).method_22913(1.0f, 0.5f).method_1336(0, 0, 0, 127).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
        }
        matrices.method_22903();
        int white = 0xFFFFFF;
        int black = 0;
        matrices.method_22904((double)(-size), -4.5, 0.0);
        matrices.method_22905(textScale, textScale, textScale);
        modelViewMatrix = matrices.method_23760().method_23761();
        mc.field_1772.method_27521(name, 0.0f, 0.0f, white, false, modelViewMatrix, (class_4597)immediate, false, black, light);
        float s1 = 0.75f;
        matrices.method_22903();
        matrices.method_22905(s1, s1, s1);
        modelViewMatrix = matrices.method_23760().method_23761();
        int h = config.getHpTextHeight();
        String maxHpStr = String.format("%s%.2f", class_124.field_1067, Float.valueOf(entity.method_6063())).replaceAll("\\.00$", "");
        String hpStr = String.format("%.2f", Float.valueOf(health)).replaceAll("\\.00$", "");
        String percStr = String.format("%.2f%%", Float.valueOf(percent)).replace(".00%", "%");
        if (maxHpStr.endsWith(".00")) {
            maxHpStr = maxHpStr.substring(0, maxHpStr.length() - 3);
        }
        if (hpStr.endsWith(".00")) {
            hpStr = hpStr.substring(0, hpStr.length() - 3);
        }
        if (config.showCurrentHP()) {
            mc.field_1772.method_27521(hpStr, 2.0f, (float)h, white, false, modelViewMatrix, (class_4597)immediate, false, black, light);
        }
        if (config.canShowMaxHP()) {
            mc.field_1772.method_27521(maxHpStr, (float)((int)(size / (textScale * s1) * 2.0f) - 2 - mc.field_1772.method_1727(maxHpStr)), (float)h, white, false, modelViewMatrix, (class_4597)immediate, false, black, light);
        }
        if (config.canShowPercentage()) {
            mc.field_1772.method_27521(percStr, (float)((int)(size / (textScale * s1))) - (float)mc.field_1772.method_1727(percStr) / 2.0f, (float)h, white, false, modelViewMatrix, (class_4597)immediate, false, black, light);
        }
        if (config.isDebugInfoEnabled() && mc.field_1690.field_1866) {
            mc.field_1772.method_27521(String.format("ID: \"%s\"", class_2378.field_11145.method_10221((Object)entity.method_5864())), 0.0f, (float)(h + 16), white, false, modelViewMatrix, (class_4597)immediate, false, black, light);
        }
        matrices.method_22909();
        matrices.method_22903();
        int off = 0;
        s1 = 0.5f;
        matrices.method_22905(s1, s1, s1);
        matrices.method_22904((double)(size / (textScale * s1) * 2.0f), 0.0, 0.0);
        mc.method_1531().method_22813(class_1059.field_5275);
        if (icon != null && config.canShowAttributes()) {
            this.renderIcon(off, 0, icon, matrices, (class_4597)immediate, light);
            off -= 16;
        }
        if ((armor = entity.method_6096()) > 0 && config.canShowArmor()) {
            int i;
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!config.canShowGroupArmor()) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            icon = new class_1799((class_1935)class_1802.field_8523);
            for (i = 0; i < ironArmor; ++i) {
                this.renderIcon(off, 0, icon, matrices, (class_4597)immediate, light);
                off -= 4;
            }
            icon = new class_1799((class_1935)class_1802.field_8058);
            for (i = 0; i < diamondArmor; ++i) {
                this.renderIcon(off, 0, icon, matrices, (class_4597)immediate, light);
                off -= 4;
            }
        }
        matrices.method_22909();
        matrices.method_22909();
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderIcon(int x, int y, @NotNull class_1799 icon, class_4587 matrices, class_4597 vertexConsumers, int light) {
        class_310 mc = class_310.method_1551();
        matrices.method_22903();
        matrices.method_22907(class_1160.field_20707.method_23214(-90.0f));
        matrices.method_22904((double)(y - 16), (double)(x - 16), 0.0);
        matrices.method_22905(16.0f, 16.0f, 1.0f);
        try {
            class_1087 bakedModel = mc.method_1480().method_4012().method_3308(icon);
            class_1058 sprite = bakedModel.method_4711();
            class_4587.class_4665 entry = matrices.method_23760();
            class_1159 modelViewMatrix = entry.method_23761();
            class_1160 normal = new class_1160(0.0f, 1.0f, 0.0f);
            normal.method_23215(entry.method_23762());
            class_4588 buffer = vertexConsumers.getBuffer(SalutemRenderPhase.getNoIconType());
            if (icon.method_7960()) {
                buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                buffer.method_22918(modelViewMatrix, 0.0f, 1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                buffer.method_22918(modelViewMatrix, 1.0f, 1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
                buffer.method_22918(modelViewMatrix, 1.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            } else {
                buffer = vertexConsumers.getBuffer(SalutemRenderPhase.getHealthBarType(class_1059.field_5275));
                buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_22913(sprite.method_4594(), sprite.method_4575()).method_1336(255, 255, 255, 255).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
                buffer.method_22918(modelViewMatrix, 0.0f, 1.0f, 0.0f).method_22913(sprite.method_4577(), sprite.method_4575()).method_1336(255, 255, 255, 255).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
                buffer.method_22918(modelViewMatrix, 1.0f, 1.0f, 0.0f).method_22913(sprite.method_4577(), sprite.method_4593()).method_1336(255, 255, 255, 255).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
                buffer.method_22918(modelViewMatrix, 1.0f, 0.0f, 0.0f).method_22913(sprite.method_4594(), sprite.method_4593()).method_1336(255, 255, 255, 255).method_22914(normal.method_4943(), normal.method_4945(), normal.method_4947()).method_22916(light).method_1344();
            }
            buffer = vertexConsumers.getBuffer(SalutemRenderPhase.getNoIconType());
            buffer.method_22918(modelViewMatrix, 0.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            buffer.method_22918(modelViewMatrix, 0.0f, 1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            buffer.method_22918(modelViewMatrix, 1.0f, 1.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
            buffer.method_22918(modelViewMatrix, 1.0f, 0.0f, 0.0f).method_1336(0, 0, 0, 0).method_1344();
        }
        catch (Exception ignored) {
            matrices.method_22909();
            return;
        }
        matrices.method_22909();
    }

    @Override
    public void renderEntity(class_4587 matrices, class_4597.class_4598 immediate, class_4184 camera, SalutemConfig config, class_1309 entity, int light, class_1799 icon) {
        this.render(matrices, immediate, camera, config, entity, light, icon, false);
    }

    @Override
    public void renderBossEntity(class_4587 matrices, class_4597.class_4598 immediate, class_4184 camera, SalutemConfig config, class_1309 entity, int light, class_1799 icon) {
        this.render(matrices, immediate, camera, config, entity, light, icon, true);
    }
}

