/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public class ScreenshotRenderer {
    public static void renderScreenshot(double screenHeight, double screenWidth, int alpha) {
        Minecraft mc = Minecraft.func_71410_x();
        float imageRatio = ScreenshotLoader.getImageRatio();
        float windowRatio = (float)mc.func_228018_at_().func_198105_m() / (float)mc.func_228018_at_().func_198083_n();
        float offset = 1.0f - windowRatio / imageRatio;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        mc.func_110434_K().func_110577_a(ScreenshotLoader.SCREENSHOT);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_(0.0, screenHeight, 0.0).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offset / 2.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(screenWidth, screenHeight, 0.0).func_225586_a_(255, 255, alpha, alpha).func_225583_a_(1.0f - offset / 2.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_(screenWidth, 0.0, 0.0).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f - offset / 2.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_(0.0, 0.0, 0.0).func_225586_a_(255, 255, 255, alpha).func_225583_a_(offset / 2.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static class Fader {
        private static float elapsedTime = 0.0f;

        public static void tick(float partialTicks) {
            elapsedTime += partialTicks;
        }

        public static float getFadeTime() {
            return ((Integer)Config.FadeTime.get()).intValue();
        }

        public static float getHoldTime() {
            return ((Integer)Config.HoldTime.get()).intValue();
        }

        public static float getAlpha() {
            if (Fader.getFadeTime() == 0.0f) {
                return elapsedTime < Fader.getHoldTime() ? 1.0f : 0.0f;
            }
            return Math.min(1.0f - (elapsedTime - Fader.getHoldTime()) / Fader.getFadeTime(), 1.0f);
        }

        public static boolean isHolding() {
            return elapsedTime <= Fader.getHoldTime();
        }

        public static boolean isFading() {
            return elapsedTime != 0.0f && elapsedTime < Fader.getFadeTime() + Fader.getHoldTime();
        }

        public static void reset() {
            elapsedTime = 0.0f;
        }
    }
}

