/*
 * Decompiled with CFR 0.152.
 */
package com.daderpduck.seamless_loading_screen;

import com.daderpduck.seamless_loading_screen.ScreenshotLoader;
import com.daderpduck.seamless_loading_screen.SeamlessLoadingScreen;
import com.daderpduck.seamless_loading_screen.config.Config;
import com.daderpduck.seamless_loading_screen.events.OFFpsDrawEvent;
import com.daderpduck.seamless_loading_screen.events.OFLagometerEvent;
import com.daderpduck.seamless_loading_screen.mixin.WindowAccessor;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.commons.io.FilenameUtils;

public class ScreenshotTaker
extends Screen {
    private static boolean takingScreenshot = false;
    private static boolean saveScreenshot = true;
    private static boolean hideGUI;
    private static final List<Consumer<Minecraft>> consumers;
    private final Consumer<RenderGameOverlayEvent.Pre> cancelOverlayListener = this::cancelGuiOverlay;
    private final Consumer<OFFpsDrawEvent> drawFpsListener = this::cancelFpsDraw;
    private final Consumer<OFLagometerEvent> lagometerListener = this::cancelLagometer;

    protected ScreenshotTaker() {
        super((ITextComponent)new TranslationTextComponent("connect.joining"));
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.cancelOverlayListener);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.drawFpsListener);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this.lagometerListener);
    }

    public static void takeScreenshot() {
        SeamlessLoadingScreen.LOGGER.info("Taking screenshot (takingScreenshot: {}, saveScreenshot: {})", (Object)takingScreenshot, (Object)saveScreenshot);
        Minecraft mc = Minecraft.func_71410_x();
        if (!takingScreenshot && mc.field_71441_e != null) {
            takingScreenshot = true;
            hideGUI = mc.field_71474_y.field_74319_N;
            mc.field_71474_y.field_74319_N = true;
            Config.ScreenshotResolution resolution = (Config.ScreenshotResolution)((Object)Config.Resolution.get());
            ScreenshotTaker.resizeScreen(mc, resolution.width, resolution.height);
            mc.func_147108_a((Screen)new ScreenshotTaker());
        }
    }

    public static void takeScreenshot(Consumer<Minecraft> consumer) {
        consumers.add(consumer);
        ScreenshotTaker.takeScreenshot();
    }

    public static void shouldSaveScreenshot(boolean b) {
        saveScreenshot = b;
    }

    private static void resizeScreen(Minecraft mc, int width, int height) {
        WindowAccessor windowAccessor = (WindowAccessor)mc.func_228018_at_();
        windowAccessor.setFramebufferWidth(width);
        windowAccessor.setFramebufferHeight(height);
        mc.func_213226_a();
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!takingScreenshot) {
            return;
        }
        Minecraft mc = this.field_230706_i_;
        if (mc == null) {
            return;
        }
        this.writeScreenshot();
        mc.field_71474_y.field_74319_N = hideGUI;
        takingScreenshot = false;
        ScreenshotTaker.resizeScreen(mc, mc.func_228018_at_().func_198105_m(), mc.func_228018_at_().func_198083_n());
        MinecraftForge.EVENT_BUS.unregister(this.cancelOverlayListener);
        MinecraftForge.EVENT_BUS.unregister(this.drawFpsListener);
        MinecraftForge.EVENT_BUS.unregister(this.lagometerListener);
        for (Consumer<Minecraft> consumer : consumers) {
            consumer.accept(mc);
        }
        consumers.clear();
    }

    private void writeScreenshot() {
        if (!saveScreenshot) {
            return;
        }
        if (ScreenshotLoader.getCurrentScreenshotPath() == null) {
            SeamlessLoadingScreen.LOGGER.error("Screenshot path is null!");
            return;
        }
        Minecraft mc = this.field_230706_i_;
        if (mc == null) {
            return;
        }
        try (NativeImage screenshotImage = ScreenShotHelper.func_198052_a((int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (Framebuffer)mc.func_147110_a());){
            File screenshotPath = ScreenshotLoader.getCurrentScreenshotPath();
            SeamlessLoadingScreen.LOGGER.info("Saving screenshot at {}", (Object)screenshotPath.getPath());
            File tempFile = File.createTempFile("slsscreenshot", ".png");
            tempFile.deleteOnExit();
            screenshotImage.func_209271_a(tempFile);
            Files.move(tempFile.toPath(), screenshotPath.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.deleteIfExists(tempFile.toPath());
            if (((Boolean)Config.ArchiveScreenshots.get()).booleanValue()) {
                String fileName = FilenameUtils.removeExtension((String)screenshotPath.getName());
                File archivePath = new File("screenshots/worlds/archive/" + fileName + "_" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + ".png");
                SeamlessLoadingScreen.LOGGER.info("Archived screenshot at {}", (Object)archivePath.getPath());
                screenshotImage.func_209271_a(archivePath);
            }
        }
        catch (IOException e) {
            SeamlessLoadingScreen.LOGGER.error("Failed to save screenshot", (Throwable)e);
        }
    }

    private void cancelGuiOverlay(RenderGameOverlayEvent.Pre event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    private void cancelFpsDraw(OFFpsDrawEvent event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    private void cancelLagometer(OFLagometerEvent event) {
        if (takingScreenshot) {
            event.setCanceled(true);
        }
    }

    static {
        consumers = new ArrayList<Consumer<Minecraft>>();
    }
}

