/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import com.lothrazar.simpletomb.helper.WorldHelper;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocationBlockPos {
    public int x;
    public int y;
    public int z;
    public String dim;
    public static final LocationBlockPos ORIGIN = new LocationBlockPos(0, 0, 0, "");

    public LocationBlockPos(BlockPos pos, World world) {
        this(pos, WorldHelper.dimensionToString(world));
    }

    public LocationBlockPos(BlockPos pos, String dim) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), dim);
    }

    public LocationBlockPos(int x, int y, int z, String dim) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.dim = dim;
    }

    public LocationBlockPos(Entity entity) {
        this(entity.func_233580_cy_(), entity.field_70170_p);
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean equals(LocationBlockPos loc) {
        return loc.x == this.x && loc.y == this.y && loc.z == this.z && loc.dim.equalsIgnoreCase(this.dim);
    }

    public boolean isOrigin() {
        return this.equals(ORIGIN);
    }

    public double getDistance(BlockPos pos) {
        double deltX = this.x - pos.func_177958_n();
        double deltY = this.y - pos.func_177956_o();
        double deltZ = this.z - pos.func_177952_p();
        return Math.sqrt(deltX * deltX + deltY * deltY + deltZ * deltZ);
    }

    public String toString() {
        return String.format("%s (%d, %d, %d)", this.dim, this.x, this.y, this.z);
    }
}

