/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;

public class PlayerTombRecords {
    UUID playerId;
    public List<CompoundNBT> playerGraves = new ArrayList<CompoundNBT>();

    public PlayerTombRecords(UUID id, CompoundNBT first) {
        this.playerId = id;
        this.playerGraves.add(first);
    }

    public PlayerTombRecords() {
    }

    public CompoundNBT getGrave(int index) {
        if (index >= this.playerGraves.size()) {
            return null;
        }
        return this.playerGraves.get(index);
    }

    public void read(CompoundNBT data, UUID playerId) {
        this.playerId = playerId;
        if (data.func_74764_b("simpletomb")) {
            ListNBT glist = data.func_150295_c("simpletomb", 10);
            for (int i = 0; i < glist.size(); ++i) {
                this.playerGraves.add(glist.func_150305_b(i));
            }
        }
    }

    public CompoundNBT write() {
        CompoundNBT data = new CompoundNBT();
        ListNBT glist = new ListNBT();
        for (CompoundNBT g : this.playerGraves) {
            glist.add((Object)g);
        }
        data.func_218657_a("simpletomb", (INBT)glist);
        return data;
    }

    public static BlockPos getPos(CompoundNBT grave) {
        return NBTUtil.func_186861_c((CompoundNBT)grave.func_74775_l("pos"));
    }

    public static String getDim(CompoundNBT grave) {
        return grave.func_74779_i("dimension");
    }

    public static List<ItemStack> getDrops(CompoundNBT grave) {
        ListNBT drops = grave.func_150295_c("drops", 10);
        ArrayList<ItemStack> done = new ArrayList<ItemStack>();
        for (int i = 0; i < drops.size(); ++i) {
            done.add(ItemStack.func_199557_a((CompoundNBT)drops.func_150305_b(i)));
        }
        return done;
    }

    public void deleteAll() {
        this.playerGraves = new ArrayList<CompoundNBT>();
    }

    public String getCoordinatesAsString(BlockPos pos) {
        return "" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p();
    }

    public String toDisplayString(int i) {
        CompoundNBT gd = this.getGrave(i);
        return String.format("[%d] (%s) (%s) {%d}", i, PlayerTombRecords.getDim(gd), this.getCoordinatesAsString(PlayerTombRecords.getPos(gd)), PlayerTombRecords.getDrops(gd).size());
    }
}

