/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.data.TombCommands;
import com.lothrazar.simpletomb.event.PlayerTombEvents;
import com.lothrazar.simpletomb.helper.WorldHelper;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CommandEvents {
    private static final String ARG_SELECTED = "selected";
    private static final String ARG_PLAYER = "player";

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        CommandDispatcher r = event.getDispatcher();
        r.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"simpletomb").requires(p -> p.func_197034_c(3))).then(Commands.func_197057_a((String)TombCommands.RESTORE.toString()).then(Commands.func_197056_a((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.func_197108_a()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSource>)cs, b)).then(Commands.func_197056_a((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeRestore((CommandContext<CommandSource>)x, this.getPlayerProfile((CommandContext<CommandSource>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.func_197057_a((String)TombCommands.KEY.toString()).then(Commands.func_197056_a((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.func_197108_a()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSource>)cs, b)).then(Commands.func_197056_a((String)ARG_SELECTED, (ArgumentType)IntegerArgumentType.integer()).executes(x -> this.exeKey((CommandContext<CommandSource>)x, this.getPlayerProfile((CommandContext<CommandSource>)x), IntegerArgumentType.getInteger((CommandContext)x, (String)ARG_SELECTED))))))).then(Commands.func_197057_a((String)TombCommands.LIST.toString()).then(Commands.func_197056_a((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.func_197108_a()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSource>)cs, b)).executes(x -> this.exeList((CommandContext<CommandSource>)x, this.getPlayerProfile((CommandContext<CommandSource>)x)))))).then(Commands.func_197057_a((String)TombCommands.DELETE.toString()).then(Commands.func_197056_a((String)ARG_PLAYER, (ArgumentType)GameProfileArgument.func_197108_a()).suggests((cs, b) -> this.buildPlayerArg((CommandContext<CommandSource>)cs, b)).executes(x -> this.exeDelete((CommandContext<CommandSource>)x, this.getPlayerProfile((CommandContext<CommandSource>)x))))));
    }

    private CompletableFuture<Suggestions> buildPlayerArg(CommandContext<CommandSource> cs, SuggestionsBuilder b) {
        return ISuggestionProvider.func_197013_a(((CommandSource)cs.getSource()).func_197028_i().func_184103_al().func_181057_v().stream().map(p -> p.func_146103_bH().getName()), (SuggestionsBuilder)b);
    }

    private GameProfile getPlayerProfile(CommandContext<CommandSource> ctx) throws CommandSyntaxException {
        return GameProfileArgument.func_197109_a(ctx, (String)ARG_PLAYER).stream().findFirst().orElse(null);
    }

    private int exeDelete(CommandContext<CommandSource> ctx, GameProfile target) throws CommandSyntaxException {
        ServerPlayerEntity user = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            int previous = found.playerGraves.size();
            found.deleteAll();
            TranslationTextComponent msg = new TranslationTextComponent("Deleted: " + previous);
            msg.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
            user.func_145747_a((ITextComponent)msg, user.func_110124_au());
        }
        return 0;
    }

    private int exeList(CommandContext<CommandSource> ctx, GameProfile target) throws CommandSyntaxException {
        ServerPlayerEntity user = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null && found.playerGraves.size() > 0) {
            for (int i = 0; i < found.playerGraves.size(); ++i) {
                TranslationTextComponent msg = new TranslationTextComponent(found.toDisplayString(i));
                msg.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
                user.func_145747_a((ITextComponent)msg, user.func_110124_au());
            }
        } else {
            TranslationTextComponent msg = new TranslationTextComponent("Found: #0");
            msg.func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GOLD));
            user.func_145747_a((ITextComponent)msg, user.func_110124_au());
        }
        return 0;
    }

    private int exeKey(CommandContext<CommandSource> ctx, GameProfile target, int index) throws CommandSyntaxException {
        ServerPlayerEntity user = ((CommandSource)ctx.getSource()).func_197035_h();
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            CompoundNBT grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index " + index + "; try between 0 and  " + (found.playerGraves.size() - 1));
                return 1;
            }
            LocationBlockPos spawnPos = new LocationBlockPos(PlayerTombRecords.getPos(grave), PlayerTombRecords.getDim(grave));
            ItemStack key = new ItemStack((IItemProvider)TombRegistry.GRAVE_KEY);
            TombRegistry.GRAVE_KEY.setTombPos(key, spawnPos);
            PlayerTombEvents.putKeyName(target.getName(), key);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)user, (ItemStack)key);
        }
        return 0;
    }

    private int exeRestore(CommandContext<CommandSource> ctx, GameProfile target, int index) throws CommandSyntaxException {
        ServerPlayerEntity user = ((CommandSource)ctx.getSource()).func_197035_h();
        TranslationTextComponent msg = new TranslationTextComponent("Attempting to restore tomb [" + index + "] for player " + target.getName() + ":" + target.getId());
        user.func_145747_a((ITextComponent)msg, user.func_110124_au());
        PlayerTombRecords found = ModTomb.GLOBAL.findGrave(target.getId());
        if (found != null) {
            BlockState state;
            CompoundNBT grave = found.playerGraves.get(index);
            if (grave == null) {
                ModTomb.LOGGER.error("Invalid grave index " + index + "; try between 0 and  " + (found.playerGraves.size() - 1));
                return 1;
            }
            BlockPos pos = PlayerTombRecords.getPos(grave);
            String dim = PlayerTombRecords.getDim(grave);
            List<ItemStack> drops = PlayerTombRecords.getDrops(grave);
            RegistryKey dimKey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)ResourceLocation.func_208304_a((String)dim));
            ServerWorld targetWorld = ((CommandSource)ctx.getSource()).func_197023_e().func_73046_m().func_71218_a(dimKey);
            boolean wasPlaced = WorldHelper.placeGrave((World)targetWorld, pos, state = PlayerTombEvents.getRandomGrave(targetWorld, Direction.NORTH));
            if (wasPlaced) {
                TileEntityTomb tile = (TileEntityTomb)targetWorld.func_175625_s(pos);
                tile.initTombstoneOwner(target);
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                for (ItemStack d : drops) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)d.func_77946_l(), (boolean)false);
                }
            }
            msg = new TranslationTextComponent("Restored tomb with at [" + pos + "] in " + dim);
            user.func_145747_a((ITextComponent)msg, user.func_110124_au());
        }
        return 0;
    }
}

