/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.event;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.DeathHelper;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.data.PlayerTombRecords;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.logging.log4j.Level;

public class PlayerTombEvents {
    public Map<UUID, PlayerTombRecords> grv = new HashMap<UUID, PlayerTombRecords>();
    private static final String TOMB_FILE_EXT = ".mctomb";
    private static final String TB_SOULBOUND_STACKS = "tb_soulbound_stacks";

    public PlayerTombRecords findGrave(UUID id) {
        if (this.grv.containsKey(id)) {
            return this.grv.get(id);
        }
        return null;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onPlayerLogged(PlayerEvent.PlayerLoggedInEvent event) {
        if (EntityHelper.isValidPlayerMP((Entity)event.getPlayer())) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            assert (player.func_184102_h() != null);
            CompoundNBT playerData = player.getPersistentData();
            if (playerData.func_74764_b("PlayerPersisted")) {
                CompoundNBT persistantData = playerData.func_74775_l("PlayerPersisted");
            } else {
                CompoundNBT persistantData = new CompoundNBT();
                playerData.func_218657_a("PlayerPersisted", (INBT)persistantData);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onDetonate(ExplosionEvent.Detonate event) {
        event.getAffectedBlocks().removeIf(blockPos -> event.getWorld().func_180495_p(blockPos).func_177230_c() instanceof BlockTomb);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity player = event.getPlayer();
        if (EntityHelper.isValidPlayerMP((Entity)player) && !player.func_175149_v()) {
            CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
            ListNBT stackList = persistentTag.func_150295_c(TB_SOULBOUND_STACKS, 10);
            for (int i = 0; i < stackList.size(); ++i) {
                ItemStack stack = ItemStack.func_199557_a((CompoundNBT)stackList.func_150305_b(i));
                if (stack.func_190926_b()) continue;
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
            }
            persistentTag.func_82580_o(TB_SOULBOUND_STACKS);
            player.field_71069_bz.func_75142_b();
        }
    }

    private void storeSoulboundsOnBody(PlayerEntity player, List<ItemStack> keys) {
        CompoundNBT persistentTag = EntityHelper.getPersistentTag(player);
        ListNBT stackList = new ListNBT();
        persistentTag.func_218657_a(TB_SOULBOUND_STACKS, (INBT)stackList);
        for (ItemStack key : keys) {
            stackList.add((Object)key.serializeNBT());
        }
        keys.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public void onPlayerDrops(LivingDropsEvent event) {
        if (!((Boolean)ConfigTomb.TOMBENABLED.get()).booleanValue()) {
            return;
        }
        if (!EntityHelper.isValidPlayer((Entity)event.getEntityLiving()) || WorldHelper.isRuleKeepInventory((PlayerEntity)event.getEntityLiving())) {
            return;
        }
        this.saveBackup(event);
        this.placeTombstone(event);
    }

    @SubscribeEvent
    public void onSaveFile(PlayerEvent.SaveToFile event) {
        PlayerEntity player = event.getPlayer();
        File mctomb = new File(event.getPlayerDirectory(), player.func_110124_au() + TOMB_FILE_EXT);
        if (this.grv.containsKey(player.func_110124_au())) {
            PlayerTombRecords dataToSave = this.grv.get(player.func_110124_au());
            CompoundNBT data = dataToSave.write();
            try {
                FileOutputStream fileoutputstream = new FileOutputStream(mctomb);
                CompressedStreamTools.func_74799_a((CompoundNBT)data, (OutputStream)fileoutputstream);
                fileoutputstream.close();
            }
            catch (IOException e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public void onLoadFile(PlayerEvent.LoadFromFile event) {
        PlayerEntity player = event.getPlayer();
        File mctomb = new File(event.getPlayerDirectory(), player.func_110124_au() + TOMB_FILE_EXT);
        if (mctomb.exists()) {
            try {
                FileInputStream fileinputstream = new FileInputStream(mctomb);
                CompoundNBT data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                fileinputstream.close();
                PlayerTombRecords dataLoaded = new PlayerTombRecords();
                dataLoaded.read(data, player.func_110124_au());
                if (this.grv.containsKey(player.func_110124_au())) {
                    this.grv.put(player.func_110124_au(), dataLoaded);
                } else {
                    this.grv.put(player.func_110124_au(), dataLoaded);
                }
            }
            catch (Exception e) {
                ModTomb.LOGGER.error("IO", (Throwable)e);
            }
        }
    }

    private void saveBackup(LivingDropsEvent event) {
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        Iterator it = event.getDrops().iterator();
        ListNBT drops = new ListNBT();
        boolean isEmpty = true;
        CompoundNBT tombstoneTag = new CompoundNBT();
        while (it.hasNext()) {
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
            ItemStack stack = entityItem.func_92059_d();
            drops.add((Object)stack.func_77955_b(new CompoundNBT()));
            if (stack.func_77973_b() == TombRegistry.GRAVE_KEY) continue;
            isEmpty = false;
        }
        if (!isEmpty) {
            tombstoneTag.func_74772_a("timestamp", System.currentTimeMillis());
            tombstoneTag.func_218657_a("drops", (INBT)drops);
            tombstoneTag.func_218657_a("pos", (INBT)NBTUtil.func_186859_a((BlockPos)player.func_233580_cy_()));
            tombstoneTag.func_74778_a("dimension", player.field_70170_p.func_234923_W_().func_240901_a_().toString());
            UUID pid = player.func_110124_au();
            tombstoneTag.func_74778_a("playerid", pid.toString());
            tombstoneTag.func_74778_a("playername", player.func_145748_c_().getString());
            if (this.grv.containsKey(pid)) {
                this.grv.get((Object)pid).playerGraves.add(tombstoneTag);
            } else {
                this.grv.put(pid, new PlayerTombRecords(pid, tombstoneTag));
            }
        }
    }

    private void placeTombstone(LivingDropsEvent event) {
        boolean hasDrop;
        ServerPlayerEntity player = (ServerPlayerEntity)event.getEntityLiving();
        ServerWorld world = player.func_71121_q();
        Iterator it = event.getDrops().iterator();
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>();
        while (it.hasNext()) {
            ItemStack stack;
            ItemEntity entityItem = (ItemEntity)it.next();
            if (entityItem == null || entityItem.func_92059_d().func_190926_b() || (stack = entityItem.func_92059_d()).func_77973_b() != TombRegistry.GRAVE_KEY) continue;
            keys.add(stack.func_77946_l());
            it.remove();
        }
        List<ItemEntity> itemsPickedUpFromGround = this.pickupFromGround((PlayerEntity)player, keys);
        this.storeSoulboundsOnBody((PlayerEntity)player, keys);
        boolean bl = hasDrop = event.getDrops().size() > 0 || itemsPickedUpFromGround.size() > 0;
        if (!hasDrop) {
            MessageType.MESSAGE_NO_LOOT_FOR_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            return;
        }
        BlockPos initPos = WorldHelper.getInitialPos((World)world, new BlockPos((Vector3i)player.func_233580_cy_()));
        LocationBlockPos spawnPos = WorldHelper.findGraveSpawn((PlayerEntity)player, initPos);
        if (spawnPos == null || spawnPos.toBlockPos() == null) {
            MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_NO_PLACE_FOR_GRAVE.getTranslation(new Object[0]));
            return;
        }
        Direction facing = player.func_174811_aO().func_176734_d();
        BlockState state = PlayerTombEvents.getRandomGrave(world, facing);
        boolean wasPlaced = WorldHelper.placeGrave((World)world, spawnPos.toBlockPos(), state);
        if (!wasPlaced) {
            PlayerTombEvents.sendFailMessage(player);
            return;
        }
        TileEntity tile = world.func_175625_s(spawnPos.toBlockPos());
        IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
        if (!(tile instanceof TileEntityTomb) || itemHandler == null) {
            PlayerTombEvents.sendFailMessage(player);
            return;
        }
        TileEntityTomb grave = (TileEntityTomb)tile;
        grave.initTombstoneOwner((PlayerEntity)player);
        if (((Boolean)ConfigTomb.KEYGIVEN.get()).booleanValue()) {
            ItemStack key = new ItemStack((IItemProvider)TombRegistry.GRAVE_KEY);
            TombRegistry.GRAVE_KEY.setTombPos(key, spawnPos);
            PlayerTombEvents.setKeyName(player, key);
            keys.add(key);
        }
        this.storeSoulboundsOnBody((PlayerEntity)player, keys);
        for (ItemEntity entityItem : event.getDrops()) {
            if (entityItem.func_92059_d().func_190926_b()) continue;
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d().func_77946_l(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        for (ItemEntity entityItem : itemsPickedUpFromGround) {
            ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false);
            entityItem.func_92058_a(ItemStack.field_190927_a);
        }
        world.func_184138_a(spawnPos.toBlockPos(), state, state, 2);
        DeathHelper.INSTANCE.putLastGrave((PlayerEntity)player, spawnPos);
        if (((Boolean)ConfigTomb.TOMBLOG.get()).booleanValue()) {
            ModTomb.LOGGER.info(MessageType.MESSAGE_NEW_GRAVE.getTranslation(new Object[0]) + String.format("(%d, %d, %d) " + spawnPos.dim, spawnPos.x, spawnPos.y, spawnPos.z));
        }
        if (((Boolean)ConfigTomb.TOMBCHAT.get()).booleanValue()) {
            MessageType.MESSAGE_NEW_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
            MessageType.MESSAGE_JOURNEYMAP.sendSpecialMessage((PlayerEntity)player, spawnPos.x, spawnPos.y, spawnPos.z, spawnPos.dim);
        }
    }

    public static void sendFailMessage(ServerPlayerEntity player) {
        MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.sendSpecialMessage((PlayerEntity)player, new Object[0]);
        ModTomb.LOGGER.log(Level.INFO, MessageType.MESSAGE_FAIL_TO_PLACE_GRAVE.getTranslation(new Object[0]));
    }

    public static void setKeyName(ServerPlayerEntity player, ItemStack key) {
        PlayerTombEvents.putKeyName(player.func_200200_C_().getString(), key);
    }

    public static void putKeyName(String player, ItemStack key) {
        if (((Boolean)ConfigTomb.KEYNAMED.get()).booleanValue()) {
            TranslationTextComponent text = new TranslationTextComponent(player);
            text.func_230529_a_((ITextComponent)new TranslationTextComponent(" "));
            text.func_230529_a_(key.func_200301_q());
            text.func_240699_a_(TextFormatting.GOLD);
            key.func_200302_a((ITextComponent)text);
        }
    }

    static BlockState getRandomGrave(ServerWorld world, Direction facing) {
        BlockTomb[] graves = new BlockTomb[]{TombRegistry.GRAVE_SIMPLE, TombRegistry.GRAVE_NORMAL, TombRegistry.GRAVE_CROSS, TombRegistry.TOMBSTONE};
        BlockState state = graves[world.field_73012_v.nextInt(graves.length)].func_176223_P();
        state = (BlockState)state.func_206870_a(BlockTomb.FACING, (Comparable)facing);
        state = (BlockState)state.func_206870_a((Property)BlockTomb.MODEL_TEXTURE, (Comparable)Integer.valueOf(world.field_73012_v.nextInt(2)));
        return state;
    }

    private List<ItemEntity> pickupFromGround(PlayerEntity player, ArrayList<ItemStack> keys) {
        double range = ((Integer)ConfigTomb.TOMBEXTRAITEMS.get()).intValue();
        if (range == 0.0) {
            return new ArrayList<ItemEntity>();
        }
        int posX = player.func_233580_cy_().func_177958_n();
        int posY = player.func_233580_cy_().func_177956_o();
        int posZ = player.func_233580_cy_().func_177952_p();
        return player.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB((double)posX - range, (double)posY - range, (double)posZ - range, (double)posX + range, (double)posY + range, (double)posZ + range));
    }
}

