/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.slotlock;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lucaargolo.slotlock.mixin.CreativeSlotAccessor;
import io.github.lucaargolo.slotlock.mixin.KeyBindingAccessor;
import io.github.lucaargolo.slotlock.mixin.ServerWorldAccessor;
import io.github.lucaargolo.slotlock.mixin.SlotAccessor;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_1132;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_481;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class Slotlock
implements ClientModInitializer {
    public static String MOD_ID = "slotlock";
    public static Logger LOGGER = LogManager.getLogger((String)MOD_ID);
    public static class_304 lockBinding;
    public static String currentKey;
    public static boolean isSaveDirty;
    private long lastDirtyCheck = System.currentTimeMillis();
    private static LinkedHashSet<Integer> lockedSlots;

    public void onInitializeClient() {
        lockBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.slotlock", class_3675.class_307.field_1668, 342, "key.categories.inventory"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            long currentDirtyCheck = System.currentTimeMillis();
            if (currentDirtyCheck - this.lastDirtyCheck > 2000L) {
                if (isSaveDirty) {
                    File slotLockFile = new File(class_310.method_1551().field_1697, "slotlock.json");
                    Path slotLockPath = Paths.get(slotLockFile.getAbsolutePath(), new String[0]);
                    String json = "{ }";
                    try {
                        json = new String(Files.readAllBytes(slotLockPath), StandardCharsets.UTF_8);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    JsonObject jsonObject = (JsonObject)new Gson().fromJson(json, JsonObject.class);
                    JsonArray jsonArray = new JsonArray();
                    lockedSlots.forEach(arg_0 -> ((JsonArray)jsonArray).add(arg_0));
                    jsonObject.add(currentKey, (JsonElement)jsonArray);
                    try {
                        Files.write(slotLockPath, jsonObject.toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        LOGGER.info("Successfully updated slotlock file");
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to update slotlock file");
                    }
                    isSaveDirty = false;
                }
                this.lastDirtyCheck = currentDirtyCheck;
            }
        });
    }

    public static LinkedHashSet<Integer> getLockedSlots() {
        return (LinkedHashSet)lockedSlots.clone();
    }

    public static boolean isLocked(int slot) {
        return lockedSlots.contains(slot);
    }

    public static void lockSlot(int slot) {
        lockedSlots.add(slot);
        isSaveDirty = true;
    }

    public static void unlockSlot(int slot) {
        lockedSlots.remove(slot);
        isSaveDirty = true;
    }

    public static void handleJoinWorld(class_310 client) {
        String json;
        String key = "world";
        if (client.method_1496()) {
            class_1132 server = client.method_1576();
            if (server != null) {
                key = ((ServerWorldAccessor)server.method_30002()).getWorldProperties().method_150();
            }
        } else {
            class_642 info = client.method_1558();
            if (info != null) {
                key = info.field_3761;
            }
        }
        LOGGER.info("Loading slotlock file");
        currentKey = key;
        lockedSlots = new LinkedHashSet();
        File slotLockFile = new File(class_310.method_1551().field_1697, "slotlock.json");
        Path slotLockPath = Paths.get(slotLockFile.getAbsolutePath(), new String[0]);
        if (Files.notExists(slotLockPath, new LinkOption[0])) {
            try {
                LOGGER.info("File not found! Creating new slotlock file");
                Files.write(slotLockPath, "{ }".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                LOGGER.info("Successfully created new slotlock file");
            }
            catch (Exception e) {
                LOGGER.error("Failed to create slotlock file");
                LOGGER.error((Object)e.getStackTrace());
            }
        }
        try {
            json = new String(Files.readAllBytes(slotLockPath), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load slotlock file");
            LOGGER.error((Object)e.getStackTrace());
            json = "{ }";
        }
        JsonObject jsonObject = (JsonObject)new Gson().fromJson(json, JsonObject.class);
        JsonArray lockedSlotsJson = jsonObject.getAsJsonArray(key);
        if (lockedSlotsJson != null) {
            lockedSlotsJson.forEach(element -> {
                int slot = -1;
                try {
                    slot = element.getAsInt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (slot != -1) {
                    lockedSlots.add(slot);
                }
            });
        }
        LOGGER.info("Successfully loaded slotlock file");
    }

    public static void handleMouseClick(class_1703 handler, class_1661 playerInventory, class_1735 slot, int invSlot, int clickData, class_1713 actionType, CallbackInfo info) {
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        if (slot != null && slot.field_7871 == playerInventory && Slotlock.isLocked(((SlotAccessor)slot).getIndex())) {
            info.cancel();
        }
        if (slot != null && actionType == class_1713.field_7793) {
            class_1799 pickedStack = playerInventory.method_7399();
            handler.field_7761.forEach(handlerSlot -> {
                int slotIndex = ((SlotAccessor)handlerSlot).getIndex();
                if (handlerSlot.field_7871 == playerInventory && Slotlock.isLocked(slotIndex) && Slotlock.canMergeItems(pickedStack, handlerSlot.method_7677())) {
                    info.cancel();
                }
            });
        }
        if (actionType == class_1713.field_7794 && invSlot >= 0 && invSlot < handler.field_7761.size()) {
            class_1735 slot2 = (class_1735)handler.field_7761.get(invSlot);
            if (slot2.field_7871 == playerInventory && Slotlock.isLocked(((SlotAccessor)slot2).getIndex())) {
                info.cancel();
            }
        }
        if (actionType == class_1713.field_7791) {
            for (class_1735 slot3 : handler.field_7761) {
                class_1735 finalSlot = slot3;
                if (finalSlot instanceof class_481.class_484) {
                    finalSlot = ((CreativeSlotAccessor)finalSlot).getSlot();
                }
                int index = ((SlotAccessor)finalSlot).getIndex();
                if (finalSlot.field_7871 != playerInventory || index != clickData || !Slotlock.isLocked(index)) continue;
                info.cancel();
            }
        }
    }

    public static void handleKeyPressed(class_1735 focusedSlot, class_1661 playerInventory, int keyCode, int scanCode, CallbackInfoReturnable<Boolean> info) {
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        if (keyCode != 256 && !class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            class_1735 finalSlot = focusedSlot;
            if (finalSlot instanceof class_481.class_484) {
                finalSlot = ((CreativeSlotAccessor)finalSlot).getSlot();
            }
            if (finalSlot != null) {
                int index = ((SlotAccessor)finalSlot).getIndex();
                if (finalSlot.field_7871 == playerInventory) {
                    if (lockBinding.method_1417(keyCode, scanCode)) {
                        boolean locked = Slotlock.isLocked(index);
                        if (locked) {
                            Slotlock.unlockSlot(index);
                        } else if (!finalSlot.method_7677().method_7960()) {
                            Slotlock.lockSlot(index);
                        }
                    } else if (Slotlock.isLocked(index)) {
                        info.setReturnValue((Object)true);
                    }
                }
            }
        }
    }

    public static void handleHotbarKeyPressed(class_1735 focusedSlot, class_1661 playerInventory, CallbackInfoReturnable<Boolean> info) {
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        class_1735 finalSlot = focusedSlot;
        if (finalSlot instanceof class_481.class_484) {
            finalSlot = ((CreativeSlotAccessor)finalSlot).getSlot();
        }
        if (finalSlot != null && finalSlot.field_7871 == playerInventory && Slotlock.isLocked(((SlotAccessor)finalSlot).getIndex())) {
            info.setReturnValue((Object)false);
        }
    }

    public static void handleDropSelectedItem(class_1661 playerInventory, CallbackInfoReturnable<Boolean> info) {
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        int selectedSlot = playerInventory.field_7545;
        if (Slotlock.isLocked(selectedSlot)) {
            info.setReturnValue((Object)false);
        }
    }

    public static void handleInputEvents(class_315 options, class_746 player) {
        if (!class_310.method_1551().method_18854()) {
            return;
        }
        boolean toPress = false;
        while (options.field_1831.method_1436()) {
            int selectedSlot;
            if (player.method_7325() || Slotlock.isLocked(selectedSlot = player.field_7514.field_7545)) continue;
            toPress = true;
        }
        if (toPress) {
            class_304.method_1420((class_3675.class_306)((KeyBindingAccessor)options.field_1831).getBoundKey());
        }
    }

    private static boolean canMergeItems(class_1799 first, class_1799 second) {
        if (first.method_7909() != second.method_7909()) {
            return false;
        }
        if (first.method_7919() != second.method_7919()) {
            return false;
        }
        if (first.method_7947() > first.method_7914()) {
            return false;
        }
        return class_1799.method_7975((class_1799)first, (class_1799)second);
    }

    static {
        currentKey = "world";
        isSaveDirty = false;
        lockedSlots = new LinkedHashSet();
    }
}

