/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.inventory;

import cech12.solarcooker.api.inventory.ContainerTypes;
import cech12.solarcooker.config.ServerConfig;
import cech12.solarcooker.inventory.SolarCookerResultSlot;
import cech12.solarcooker.tileentity.AbstractSolarCookerTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SolarCookerContainer
extends Container {
    private final IRecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final AbstractSolarCookerTileEntity cooker;
    protected final World world;

    public SolarCookerContainer(IRecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, PlayerInventory playerInventoryIn, AbstractSolarCookerTileEntity cooker) {
        super(ContainerTypes.SOLAR_COOKER, id);
        this.specificRecipeType = specificRecipeTypeIn;
        SolarCookerContainer.func_216962_a((IInventory)cooker, (int)2);
        this.cooker = cooker;
        cooker.func_174889_b(playerInventoryIn.field_70458_d);
        this.world = playerInventoryIn.field_70458_d.field_70170_p;
        this.func_75146_a(new Slot((IInventory)cooker, 0, 56, 17));
        this.func_75146_a((Slot)new SolarCookerResultSlot(playerInventoryIn.field_70458_d, (IInventory)cooker, 1, 116, 35));
        for (int playerInvRow = 0; playerInvRow < 3; ++playerInvRow) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventoryIn, j1 + playerInvRow * 9 + 9, 8 + j1 * 18, 84 + playerInvRow * 18));
            }
        }
        for (int playerHotbarSlot = 0; playerHotbarSlot < 9; ++playerHotbarSlot) {
            this.func_75146_a(new Slot((IInventory)playerInventoryIn, playerHotbarSlot, 8 + playerHotbarSlot * 18, 142));
        }
    }

    public SolarCookerContainer(IRecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn, int id, PlayerInventory playerInventoryIn, BlockPos pos) {
        this(specificRecipeTypeIn, id, playerInventoryIn, (AbstractSolarCookerTileEntity)playerInventoryIn.field_70458_d.field_70170_p.func_175625_s(pos));
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return this.cooker.func_70300_a(playerIn);
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 1) {
                if (!this.func_75135_a(itemstack1, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 0 ? (this.hasRecipe(itemstack1) ? !this.func_75135_a(itemstack1, 0, 1, false) : (index >= 2 && index < 29 ? !this.func_75135_a(itemstack1, 29, 38, false) : index >= 29 && index < 38 && !this.func_75135_a(itemstack1, 2, 29, false))) : !this.func_75135_a(itemstack1, 2, 38, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }

    public void func_75141_a(int slotID, @Nonnull ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    protected boolean hasRecipe(ItemStack stack) {
        if (this.world != null) {
            if (this.world.func_199532_z().func_215371_a(this.specificRecipeType, (IInventory)new Inventory(new ItemStack[]{stack}), this.world).isPresent()) {
                return true;
            }
            if (((Boolean)ServerConfig.VANILLA_RECIPES_ENABLED.get()).booleanValue()) {
                return this.world.func_199532_z().func_215370_b(ServerConfig.getRecipeType(), (IInventory)new Inventory(new ItemStack[]{stack}), this.world).stream().anyMatch(abstractCookingRecipe -> ServerConfig.isRecipeNotBlacklisted(abstractCookingRecipe.func_199560_c()));
            }
        }
        return false;
    }

    public void func_75134_a(@Nonnull PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.cooker.func_174886_c(playerIn);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressionScaled() {
        int i = this.cooker.getCookTime();
        int j = this.cooker.getCookTimeTotal();
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.cooker.getCookTime() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isSunlit() {
        return this.cooker.isSunlit();
    }
}

