/*
 * Decompiled with CFR 0.152.
 */
package cech12.solarcooker.tileentity;

import cech12.solarcooker.block.AbstractSolarCookerBlock;
import cech12.solarcooker.block.ReflectorBlock;
import cech12.solarcooker.block.SolarCookerBlock;
import cech12.solarcooker.config.ServerConfig;
import cech12.solarcooker.init.ModTags;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public abstract class AbstractSolarCookerTileEntity
extends LockableTileEntity
implements ISidedInventory,
IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity {
    private static final int[] SLOTS = new int[]{0, 1};
    private static final int[] SLOTS_UP = new int[0];
    protected static final int INPUT = 0;
    protected static final int OUTPUT = 1;
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    protected int cookTime;
    protected int cookTimeTotal;
    protected float lidAngle;
    protected float prevLidAngle;
    protected int numPlayersUsing;
    protected int reflectorCount = 0;
    protected final IRecipeType<? extends AbstractCookingRecipe> specificRecipeType;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipes = new Object2IntOpenHashMap();
    protected AbstractCookingRecipe curRecipe;
    protected ItemStack failedMatch = ItemStack.field_190927_a;
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.NORTH});

    public AbstractSolarCookerTileEntity(TileEntityType<?> tileTypeIn, IRecipeType<? extends AbstractCookingRecipe> specificRecipeTypeIn) {
        super(tileTypeIn);
        this.specificRecipeType = specificRecipeTypeIn;
    }

    private boolean hasShiningBlockAbove() {
        BlockPos checkPos;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(checkPos = this.field_174879_c.func_177984_a()).func_200131_a((IBlockReader)this.field_145850_b, checkPos)) {
            for (int i = 0; i < 5; ++i) {
                BlockState state = this.field_145850_b.func_180495_p(checkPos = checkPos.func_177984_a());
                if (state.func_235714_a_(ModTags.Blocks.SOLAR_COOKER_SHINING)) {
                    return true;
                }
                if (state.func_200131_a((IBlockReader)this.field_145850_b, checkPos)) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isSunlit() {
        if (this.field_145850_b != null) {
            if (!this.field_145850_b.field_72995_K) {
                return this.hasShiningBlockAbove() || this.field_145850_b.func_230315_m_().func_218272_d() && this.field_145850_b.func_72935_r() && !this.field_145850_b.func_72896_J() && this.field_145850_b.func_226660_f_(this.field_174879_c.func_177984_a());
            }
            return (Boolean)this.func_195044_w().func_177229_b((Property)SolarCookerBlock.SUNLIT);
        }
        return false;
    }

    public int getCookTime() {
        return this.cookTime;
    }

    public int getCookTimeTotal() {
        return this.cookTimeTotal;
    }

    public void func_230337_a_(@Nonnull BlockState stateIn, @Nonnull CompoundNBT nbtIn) {
        super.func_230337_a_(stateIn, nbtIn);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbtIn, this.items);
        this.cookTime = nbtIn.func_74762_e("CookTime");
        this.cookTimeTotal = nbtIn.func_74762_e("CookTimeTotal");
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null) {
            boolean isBurning;
            boolean dirty = false;
            this.calculateLidAngle();
            boolean isSunlit = this.isSunlit();
            if (isSunlit && !((ItemStack)this.items.get(0)).func_190926_b()) {
                AbstractCookingRecipe recipe = this.getRecipe();
                if (this.canSmelt((IRecipe<?>)recipe)) {
                    ++this.cookTime;
                    if (this.cookTime == this.cookTimeTotal) {
                        this.cookTime = 0;
                        this.cookTimeTotal = this.getRecipeCookTime();
                        if (!this.field_145850_b.field_72995_K) {
                            this.smeltItem((IRecipe<?>)recipe);
                            dirty = true;
                        }
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!isSunlit && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            boolean bl = isBurning = this.cookTime > 0;
            if (!(this.field_145850_b.field_72995_K || (Boolean)this.func_195044_w().func_177229_b((Property)SolarCookerBlock.BURNING) == isBurning && (Boolean)this.func_195044_w().func_177229_b((Property)SolarCookerBlock.SUNLIT) == isSunlit)) {
                dirty = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)((BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)SolarCookerBlock.SUNLIT, (Comparable)Boolean.valueOf(isSunlit))).func_206870_a((Property)SolarCookerBlock.BURNING, (Comparable)Boolean.valueOf(isBurning)), 3);
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    public boolean shouldLidBeOpen() {
        return this.numPlayersUsing > 0 || this.canSmelt((IRecipe<?>)this.getRecipe()) && this.isSunlit();
    }

    private void calculateLidAngle() {
        if (this.field_145850_b != null) {
            this.prevLidAngle = this.lidAngle;
            boolean shouldLidBeOpen = this.shouldLidBeOpen();
            if (shouldLidBeOpen && this.lidAngle == 0.0f) {
                this.playSound(SoundEvents.field_187657_V);
                if (!this.field_145850_b.field_72995_K) {
                    this.func_70296_d();
                }
            }
            if (!shouldLidBeOpen && this.lidAngle > 0.0f || shouldLidBeOpen && this.lidAngle < 1.0f) {
                float f1 = this.lidAngle;
                this.lidAngle = shouldLidBeOpen ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
                if (this.lidAngle > 1.0f) {
                    this.lidAngle = 1.0f;
                }
                if (this.lidAngle < 0.5f && f1 >= 0.5f) {
                    this.playSound(SoundEvents.field_187651_T);
                }
                if (this.lidAngle < 0.0f) {
                    this.lidAngle = 0.0f;
                }
            }
        }
    }

    public boolean func_145842_c(int id, int type) {
        if (id == 1) {
            this.numPlayersUsing = type;
            return true;
        }
        return super.func_145842_c(id, type);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing < 0) {
                this.numPlayersUsing = 0;
            }
            ++this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.numPlayersUsing;
            this.onOpenOrClose();
        }
    }

    protected void onOpenOrClose() {
        Block block = this.func_195044_w().func_177230_c();
        if (this.field_145850_b != null && block instanceof SolarCookerBlock) {
            this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.numPlayersUsing);
        }
    }

    private void playSound(SoundEvent soundIn) {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            double x = (double)this.field_174879_c.func_177958_n() + 0.5;
            double y = (double)this.field_174879_c.func_177956_o() + 0.5;
            double z = (double)this.field_174879_c.func_177952_p() + 0.5;
            this.field_145850_b.func_184148_a(null, x, y, z, soundIn, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    protected boolean canSmelt(@Nullable IRecipe<?> recipe) {
        ItemStack recipeOutput;
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipe != null && !(recipeOutput = recipe.func_77571_b()).func_190926_b()) {
            ItemStack output = (ItemStack)this.items.get(1);
            if (output.func_190926_b()) {
                return true;
            }
            if (!output.func_77969_a(recipeOutput)) {
                return false;
            }
            return output.func_190916_E() + recipeOutput.func_190916_E() <= output.func_77976_d();
        }
        return false;
    }

    private void smeltItem(@Nullable IRecipe<?> recipe) {
        if (recipe != null && this.canSmelt(recipe)) {
            ItemStack itemstack = (ItemStack)this.items.get(0);
            ItemStack itemstack1 = recipe.func_77571_b();
            ItemStack itemstack2 = (ItemStack)this.items.get(1);
            if (itemstack2.func_190926_b()) {
                this.items.set(1, (Object)itemstack1.func_77946_l());
            } else if (itemstack2.func_77973_b() == itemstack1.func_77973_b()) {
                itemstack2.func_190917_f(itemstack1.func_190916_E());
            }
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            itemstack.func_190918_g(1);
        }
    }

    protected int getRecipeCookTime() {
        double reflectorFactor;
        AbstractCookingRecipe rec = this.getRecipe();
        if (rec == null) {
            return 200;
        }
        this.checkForReflectors();
        double d = reflectorFactor = this.reflectorCount > 0 ? 1.0 - (1.0 - (Double)ServerConfig.MAX_REFLECTOR_TIME_FACTOR.get()) / 4.0 * (double)this.reflectorCount : 1.0;
        if (this.specificRecipeType.getClass().isInstance(rec.func_222127_g())) {
            return (int)((double)rec.func_222137_e() * reflectorFactor);
        }
        return (int)((double)rec.func_222137_e() * ((Double)ServerConfig.COOK_TIME_FACTOR.get() * reflectorFactor));
    }

    protected AbstractCookingRecipe getRecipe() {
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b() || input == this.failedMatch) {
            return null;
        }
        if (this.field_145850_b != null && this.curRecipe != null && this.curRecipe.func_77569_a((IInventory)this, this.field_145850_b)) {
            return this.curRecipe;
        }
        AbstractCookingRecipe rec = null;
        if (this.field_145850_b != null && (rec = (AbstractCookingRecipe)this.field_145850_b.func_199532_z().func_215371_a(this.specificRecipeType, (IInventory)this, this.field_145850_b).orElse(null)) == null && ((Boolean)ServerConfig.VANILLA_RECIPES_ENABLED.get()).booleanValue()) {
            rec = this.field_145850_b.func_199532_z().func_215370_b(ServerConfig.getRecipeType(), (IInventory)this, this.field_145850_b).stream().filter(abstractCookingRecipe -> ServerConfig.isRecipeNotBlacklisted(abstractCookingRecipe.func_199560_c())).findFirst().orElse(null);
        }
        this.failedMatch = rec == null ? input : ItemStack.field_190927_a;
        this.curRecipe = rec;
        return this.curRecipe;
    }

    private void checkForReflectors() {
        BlockState state;
        this.reflectorCount = 0;
        if (this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() instanceof AbstractSolarCookerBlock) {
            Direction facing = (Direction)state.func_177229_b((Property)AbstractSolarCookerBlock.FACING);
            this.reflectorCount += this.countReflectorsOnSide(facing.func_176746_e());
            this.reflectorCount += this.countReflectorsOnSide(facing.func_176735_f());
        }
    }

    private int countReflectorsOnSide(Direction direction) {
        int count = 0;
        if (this.field_145850_b != null) {
            BlockPos blockPos = this.field_174879_c.func_177972_a(direction);
            for (BlockPos position : new BlockPos[]{blockPos, blockPos.func_177984_a()}) {
                BlockState state = this.field_145850_b.func_180495_p(position);
                if (!(state.func_177230_c() instanceof ReflectorBlock) || state.func_177229_b((Property)ReflectorBlock.field_185512_D) != direction.func_176734_d()) continue;
                ++count;
            }
        }
        return count;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        if (side == Direction.UP) {
            return SLOTS_UP;
        }
        return SLOTS;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nullable Direction direction) {
        return direction != Direction.UP && index == 1;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getRecipeCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(@Nonnull PlayerEntity player) {
        if (this.field_145850_b != null && this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return index == 0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            this.usedRecipes.addTo((Object)recipe.func_199560_c(), 1);
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_235645_d_(PlayerEntity p_235645_1_) {
        List<IRecipe<?>> list = this.func_235640_a_(p_235645_1_.field_70170_p, p_235645_1_.func_213303_ch());
        p_235645_1_.func_195065_a(list);
        this.usedRecipes.clear();
    }

    public List<IRecipe<?>> func_235640_a_(World p_235640_1_, Vector3d p_235640_2_) {
        ArrayList list = Lists.newArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
            p_235640_1_.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(p_235642_4_ -> {
                list.add(p_235642_4_);
                AbstractSolarCookerTileEntity.func_235641_a_(p_235640_1_, p_235640_2_, entry.getIntValue(), ((AbstractCookingRecipe)p_235642_4_).func_222138_b());
            });
        }
        return list;
    }

    private static void func_235641_a_(World p_235641_0_, Vector3d p_235641_1_, int p_235641_2_, float p_235641_3_) {
        int i = MathHelper.func_76141_d((float)((float)p_235641_2_ * p_235641_3_));
        float f = MathHelper.func_226164_h_((float)((float)p_235641_2_ * p_235641_3_));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = ExperienceOrbEntity.func_70527_a((int)i);
            i -= j;
            p_235641_0_.func_217376_c((Entity)new ExperienceOrbEntity(p_235641_0_, p_235641_1_.field_72450_a, p_235641_1_.field_72448_b, p_235641_1_.field_72449_c, j));
        }
    }

    public void func_194018_a(@Nonnull RecipeItemHelper helper) {
        for (ItemStack itemstack : this.items) {
            helper.func_194112_a(itemstack);
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            return this.handlers[1].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getLidAngle(float partialTicks) {
        if (this.field_145850_b != null) {
            return MathHelper.func_219799_g((float)partialTicks, (float)this.prevLidAngle, (float)this.lidAngle);
        }
        return 0.0f;
    }
}

