/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.sounddeviceoptions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class SDOConfig {
    static final ForgeConfigSpec clientSpec;
    public static final SDOConfig CLIENT;
    public final ForgeConfigSpec.ConfigValue<String> activeSoundDevice;

    private SDOConfig(ForgeConfigSpec.Builder builder) {
        this.activeSoundDevice = builder.comment("The active sound device").define("activeSoundDevice", (Object)"");
    }

    @Nullable
    public static String getActiveSoundDevice() {
        String device = (String)SDOConfig.CLIENT.activeSoundDevice.get();
        if (device == null) {
            return null;
        }
        if (device.isEmpty()) {
            return null;
        }
        return device;
    }

    @Nonnull
    public static String friendlyActiveSoundDevice() {
        return SDOConfig.formatDevice(SDOConfig.getActiveSoundDevice());
    }

    public static String formatDevice(String device) {
        if (device == null) {
            return I18n.func_135052_a((String)"sounddeviceoptions.default", (Object[])new Object[0]);
        }
        if (device.startsWith("OpenAL Soft on ")) {
            return device.substring("OpenAL Soft on ".length());
        }
        return device;
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(SDOConfig::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (SDOConfig)specPair.getLeft();
    }
}

