/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.mob.PathingTarget;

public class ClientEventHandlers {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPreRenderLiving(RenderLivingEvent.Pre<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            float partialTicks = event.getPartialRenderTick();
            MatrixStack matrixStack = event.getMatrixStack();
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.calculateOrientation(partialTicks);
            climber.setRenderOrientation(renderOrientation);
            float verticalOffset = climber.getVerticalOffset(partialTicks);
            float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.field_72450_a * verticalOffset;
            float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.field_72448_b * verticalOffset;
            float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.field_72449_c * verticalOffset;
            matrixStack.func_227861_a_((double)x, (double)y, (double)z);
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(renderOrientation.yaw));
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(renderOrientation.pitch));
            matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPostRenderLiving(RenderLivingEvent.Post<?, ?> event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof IClimberEntity) {
            IClimberEntity climber = (IClimberEntity)entity;
            float partialTicks = event.getPartialRenderTick();
            MatrixStack matrixStack = event.getMatrixStack();
            IRenderTypeBuffer bufferIn = event.getBuffers();
            Orientation orientation = climber.getOrientation();
            Orientation renderOrientation = climber.getRenderOrientation();
            if (renderOrientation != null) {
                float verticalOffset = climber.getVerticalOffset(partialTicks);
                float x = climber.getAttachmentOffset(Direction.Axis.X, partialTicks) - (float)renderOrientation.normal.field_72450_a * verticalOffset;
                float y = climber.getAttachmentOffset(Direction.Axis.Y, partialTicks) - (float)renderOrientation.normal.field_72448_b * verticalOffset;
                float z = climber.getAttachmentOffset(Direction.Axis.Z, partialTicks) - (float)renderOrientation.normal.field_72449_c * verticalOffset;
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-Math.signum(0.5f - orientation.componentY - orientation.componentZ - orientation.componentX) * renderOrientation.yaw));
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-renderOrientation.pitch));
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-renderOrientation.yaw));
                if (Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
                    List<PathingTarget> pathingTargets;
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_186662_g((double)0.2f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    double rx = entity.field_70169_q + (entity.func_226277_ct_() - entity.field_70169_q) * (double)partialTicks;
                    double ry = entity.field_70167_r + (entity.func_226278_cu_() - entity.field_70167_r) * (double)partialTicks;
                    double rz = entity.field_70166_s + (entity.func_226281_cx_() - entity.field_70166_s) * (double)partialTicks;
                    Vector3d movementTarget = climber.getTrackedMovementTarget();
                    if (movementTarget != null) {
                        WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(movementTarget.func_82615_a() - 0.25, movementTarget.func_82617_b() - 0.25, movementTarget.func_82616_c() - 0.25, movementTarget.func_82615_a() + 0.25, movementTarget.func_82617_b() + 0.25, movementTarget.func_82616_c() + 0.25).func_72317_d(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    if ((pathingTargets = climber.getTrackedPathingTargets()) != null) {
                        int i = 0;
                        for (PathingTarget pathingTarget : pathingTargets) {
                            BlockPos pos = pathingTarget.pos;
                            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(pos).func_72317_d(-rx - (double)x, -ry - (double)y, -rz - (double)z), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)0.15f);
                            matrixStack.func_227860_a_();
                            matrixStack.func_227861_a_((double)pos.func_177958_n() + 0.5 - rx - (double)x, (double)pos.func_177956_o() + 0.5 - ry - (double)y, (double)pos.func_177952_p() + 0.5 - rz - (double)z);
                            matrixStack.func_227863_a_(pathingTarget.side.func_176734_d().func_229384_a_());
                            WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(-0.501, -0.501, -0.501, 0.501, -0.45, 0.501), (float)1.0f, (float)((float)i / (float)(pathingTargets.size() - 1)), (float)0.0f, (float)1.0f);
                            Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                            IVertexBuilder builder = bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_);
                            builder.func_227888_a_(matrix4f, -0.501f, -0.45f, -0.501f).func_227885_a_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).func_181675_d();
                            builder.func_227888_a_(matrix4f, 0.501f, -0.45f, 0.501f).func_227885_a_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).func_181675_d();
                            builder.func_227888_a_(matrix4f, -0.501f, -0.45f, 0.501f).func_227885_a_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).func_181675_d();
                            builder.func_227888_a_(matrix4f, 0.501f, -0.45f, -0.501f).func_227885_a_(1.0f, (float)i / (float)(pathingTargets.size() - 1), 0.0f, 1.0f).func_181675_d();
                            matrixStack.func_227865_b_();
                            ++i;
                        }
                    }
                    Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                    IVertexBuilder builder = bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_);
                    builder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(0, 1, 1, 1).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)orientation.normal.field_72450_a * 2.0f, (float)orientation.normal.field_72448_b * 2.0f, (float)orientation.normal.field_72449_c * 2.0f).func_227885_a_(1.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72317_d((double)((float)orientation.normal.field_72450_a * 2.0f), (double)((float)orientation.normal.field_72448_b * 2.0f), (double)((float)orientation.normal.field_72449_c * 2.0f)).func_186662_g((double)0.025f), (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_((double)(-x), (double)(-y), (double)(-z));
                    matrix4f = matrixStack.func_227866_c_().func_227870_a_();
                    builder.func_227888_a_(matrix4f, 0.0f, entity.func_213302_cg() * 0.5f, 0.0f).func_225586_a_(0, 1, 1, 1).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)orientation.localX.field_72450_a, entity.func_213302_cg() * 0.5f + (float)orientation.localX.field_72448_b, (float)orientation.localX.field_72449_c).func_227885_a_(1.0f, 0.0f, 0.0f, 1.0f).func_181675_d();
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72317_d((double)((float)orientation.localX.field_72450_a), (double)(entity.func_213302_cg() * 0.5f + (float)orientation.localX.field_72448_b), (double)((float)orientation.localX.field_72449_c)).func_186662_g((double)0.025f), (float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    builder.func_227888_a_(matrix4f, 0.0f, entity.func_213302_cg() * 0.5f, 0.0f).func_225586_a_(0, 1, 1, 1).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)orientation.localY.field_72450_a, entity.func_213302_cg() * 0.5f + (float)orientation.localY.field_72448_b, (float)orientation.localY.field_72449_c).func_227885_a_(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72317_d((double)((float)orientation.localY.field_72450_a), (double)(entity.func_213302_cg() * 0.5f + (float)orientation.localY.field_72448_b), (double)((float)orientation.localY.field_72449_c)).func_186662_g((double)0.025f), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                    builder.func_227888_a_(matrix4f, 0.0f, entity.func_213302_cg() * 0.5f, 0.0f).func_225586_a_(0, 1, 1, 1).func_181675_d();
                    builder.func_227888_a_(matrix4f, (float)orientation.localZ.field_72450_a, entity.func_213302_cg() * 0.5f + (float)orientation.localZ.field_72448_b, (float)orientation.localZ.field_72449_c).func_227885_a_(0.0f, 0.0f, 1.0f, 1.0f).func_181675_d();
                    WorldRenderer.func_228430_a_((MatrixStack)matrixStack, (IVertexBuilder)bufferIn.getBuffer((RenderType)RenderType.field_228614_Q_), (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0).func_72317_d((double)((float)orientation.localZ.field_72450_a), (double)(entity.func_213302_cg() * 0.5f + (float)orientation.localZ.field_72448_b), (double)((float)orientation.localZ.field_72449_c)).func_186662_g((double)0.025f), (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
                    matrixStack.func_227865_b_();
                }
                matrixStack.func_227861_a_((double)(-x), (double)(-y), (double)(-z));
            }
        }
    }
}

