/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.goal;

import java.util.EnumSet;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import org.apache.commons.lang3.tuple.Triple;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;

public class BetterLeapAtTargetGoal<T extends MobEntity>
extends Goal {
    private final T leaper;
    private final float leapMotionY;
    private LivingEntity leapTarget;
    private Vector3d forwardJumpDirection;
    private Vector3d upwardJumpDirection;

    public BetterLeapAtTargetGoal(T leapingEntity, float leapMotionYIn) {
        this.leaper = leapingEntity;
        this.leapMotionY = leapMotionYIn;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        if (!this.leaper.func_184207_aI()) {
            this.leapTarget = this.leaper.func_70638_az();
            if (this.leapTarget != null && this.leaper.func_233570_aj_()) {
                Triple<Vector3d, Vector3d, Vector3d> projectedVector = this.getProjectedVector(this.leapTarget.func_213303_ch());
                double dstSq = ((Vector3d)projectedVector.getLeft()).func_189985_c();
                double dstSqDot = ((Vector3d)projectedVector.getMiddle()).func_189985_c();
                if (dstSq >= 4.0 && dstSq <= 16.0 && dstSqDot <= (double)1.2f && this.leaper.func_70681_au().nextInt(5) == 0) {
                    this.forwardJumpDirection = ((Vector3d)projectedVector.getLeft()).func_72432_b();
                    this.upwardJumpDirection = ((Vector3d)projectedVector.getRight()).func_72432_b();
                    return true;
                }
            }
        }
        return false;
    }

    public boolean func_75253_b() {
        return !this.leaper.func_233570_aj_();
    }

    public void func_75249_e() {
        Vector3d motion = this.leaper.func_213322_ci();
        Vector3d jumpVector = this.forwardJumpDirection;
        if (jumpVector.func_189985_c() > 1.0E-7) {
            jumpVector = jumpVector.func_72432_b().func_186678_a(0.4).func_178787_e(motion.func_186678_a(0.2));
        }
        jumpVector = jumpVector.func_178787_e(this.upwardJumpDirection.func_186678_a((double)this.leapMotionY));
        jumpVector = new Vector3d(jumpVector.field_72450_a * (1.0 - Math.abs(this.upwardJumpDirection.field_72450_a)), jumpVector.field_72448_b, jumpVector.field_72449_c * (1.0 - Math.abs(this.upwardJumpDirection.field_72449_c)));
        this.leaper.func_213317_d(jumpVector);
        Orientation orientation = ((IClimberEntity)this.leaper).getOrientation();
        float rx = (float)orientation.localZ.func_72430_b(jumpVector);
        float ry = (float)orientation.localX.func_72430_b(jumpVector);
        ((MobEntity)this.leaper).field_70177_z = 270.0f - (float)Math.toDegrees(MathHelper.func_181159_b((double)rx, (double)ry));
    }

    protected Triple<Vector3d, Vector3d, Vector3d> getProjectedVector(Vector3d target) {
        Orientation orientation = ((IClimberEntity)this.leaper).getOrientation();
        Vector3d up = orientation.getGlobal(((MobEntity)this.leaper).field_70177_z, -90.0f);
        Vector3d diff = target.func_178788_d(this.leaper.func_213303_ch());
        Vector3d dot = up.func_186678_a(up.func_72430_b(diff));
        return Triple.of((Object)diff.func_178788_d(dot), (Object)dot, (Object)up);
    }
}

