/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.network.DebugPacketSender;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.movement.AdvancedGroundPathNavigator;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;
import tcb.spiderstpo.common.entity.movement.ClimberMoveController;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;

public class AdvancedClimberPathNavigator<T extends MobEntity>
extends AdvancedGroundPathNavigator<T> {
    protected final IClimberEntity climber;
    protected Direction verticalFacing = Direction.DOWN;
    protected boolean findDirectPathPoints = false;

    public AdvancedClimberPathNavigator(T entity, World worldIn, boolean checkObstructions, boolean canPathWalls, boolean canPathCeiling) {
        super(entity, worldIn, checkObstructions);
        this.climber = (IClimberEntity)entity;
        if (this.field_179695_a instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.field_179695_a;
            processor.setStartPathOnGround(false);
            processor.setCanPathWalls(canPathWalls);
            processor.setCanPathCeiling(canPathCeiling);
        }
    }

    protected Vector3d func_75502_i() {
        return this.field_75515_a.func_213303_ch().func_72441_c(0.0, (double)(this.field_75515_a.func_213302_cg() / 2.0f), 0.0);
    }

    @Nullable
    public Path func_179680_a(BlockPos pos, int checkpointRange) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)pos), 8, false, checkpointRange);
    }

    @Nullable
    public Path func_75494_a(Entity entityIn, int checkpointRange) {
        return this.func_225464_a((Set<BlockPos>)ImmutableSet.of((Object)entityIn.func_233580_cy_()), 16, true, checkpointRange);
    }

    public void func_75501_e() {
        ++this.field_75510_g;
        if (this.field_188562_p) {
            this.func_188554_j();
        }
        if (!this.func_75500_f()) {
            if (this.func_75485_k()) {
                this.func_75508_h();
            } else if (this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
                Vector3d pos = this.func_75502_i();
                Vector3d targetPos = this.field_75514_c.func_75878_a((Entity)this.field_75515_a);
                if (pos.field_72448_b > targetPos.field_72448_b && !this.field_75515_a.func_233570_aj_() && MathHelper.func_76128_c((double)pos.field_72450_a) == MathHelper.func_76128_c((double)targetPos.field_72450_a) && MathHelper.func_76128_c((double)pos.field_72449_c) == MathHelper.func_76128_c((double)targetPos.field_72449_c)) {
                    this.field_75514_c.func_75875_a();
                }
            }
            DebugPacketSender.func_218803_a((World)this.field_75513_b, (MobEntity)this.field_75515_a, (Path)this.field_75514_c, (float)this.field_188561_o);
            if (!this.func_75500_f()) {
                PathPoint targetPoint = this.field_75514_c.func_75877_a(this.field_75514_c.func_75873_e());
                Direction dir = null;
                if (targetPoint instanceof DirectionalPathPoint) {
                    dir = ((DirectionalPathPoint)targetPoint).getPathSide();
                }
                if (dir == null) {
                    dir = Direction.DOWN;
                }
                Vector3d targetPos = this.getExactPathingTarget((IBlockReader)this.field_75513_b, targetPoint.func_224759_a(), dir);
                MovementController moveController = this.field_75515_a.func_70605_aq();
                if (moveController instanceof ClimberMoveController && targetPoint instanceof DirectionalPathPoint && ((DirectionalPathPoint)targetPoint).getPathSide() != null) {
                    ((ClimberMoveController)moveController).setMoveTo(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, targetPoint.func_224759_a().func_177972_a(dir), ((DirectionalPathPoint)targetPoint).getPathSide(), this.field_75511_d);
                } else {
                    moveController.func_75642_a(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, this.field_75511_d);
                }
            }
        }
    }

    public Vector3d getExactPathingTarget(IBlockReader blockaccess, BlockPos pos, Direction dir) {
        BlockPos offsetPos = pos.func_177972_a(dir);
        VoxelShape shape = blockaccess.func_180495_p(offsetPos).func_196952_d(blockaccess, offsetPos);
        Direction.Axis axis = dir.func_176740_k();
        int sign = dir.func_82601_c() + dir.func_96559_d() + dir.func_82599_e();
        double offset = shape.func_197766_b() ? (double)sign : (sign > 0 ? shape.func_197762_b(axis) - 1.0 : shape.func_197758_c(axis));
        double marginXZ = 1.0f - this.field_75515_a.func_213311_cf() % 1.0f;
        double marginY = 1.0f - this.field_75515_a.func_213302_cg() % 1.0f;
        double pathingOffsetXZ = (double)((int)(this.field_75515_a.func_213311_cf() + 1.0f)) * 0.5;
        double pathingOffsetY = (double)((int)(this.field_75515_a.func_213302_cg() + 1.0f)) * 0.5 - (double)(this.field_75515_a.func_213302_cg() * 0.5f);
        double x = (double)offsetPos.func_177958_n() + pathingOffsetXZ + (double)dir.func_82601_c() * marginXZ;
        double y = (double)offsetPos.func_177956_o() + pathingOffsetY + (dir == Direction.DOWN ? -pathingOffsetY : 0.0) + (dir == Direction.UP ? -pathingOffsetY + marginY : 0.0);
        double z = (double)offsetPos.func_177952_p() + pathingOffsetXZ + (double)dir.func_82599_e() * marginXZ;
        switch (axis) {
            default: {
                return new Vector3d(x + offset, y, z);
            }
            case Y: {
                return new Vector3d(x, y + offset, z);
            }
            case Z: 
        }
        return new Vector3d(x, y, z + offset);
    }

    protected void func_75508_h() {
        Vector3d pos = this.func_75502_i();
        this.field_188561_o = this.field_75515_a.func_213311_cf() > 0.75f ? this.field_75515_a.func_213311_cf() / 2.0f : 0.75f - this.field_75515_a.func_213311_cf() / 2.0f;
        float maxDistanceToWaypointY = Math.max(1.0f, this.field_75515_a.func_213302_cg() > 0.75f ? this.field_75515_a.func_213302_cg() / 2.0f : 0.75f - this.field_75515_a.func_213302_cg() / 2.0f);
        int sizeX = MathHelper.func_76123_f((float)this.field_75515_a.func_213311_cf());
        int sizeY = MathHelper.func_76123_f((float)this.field_75515_a.func_213302_cg());
        int sizeZ = sizeX;
        Orientation orientation = this.climber.getOrientation();
        Vector3d upVector = orientation.getGlobal(this.field_75515_a.field_70177_z, -90.0f);
        this.verticalFacing = Direction.func_176737_a((float)((float)upVector.field_72450_a), (float)((float)upVector.field_72448_b), (float)((float)upVector.field_72449_c));
        for (int i = 4; i >= 0; --i) {
            Direction targetSide;
            if (this.field_75514_c.func_75873_e() + i >= this.field_75514_c.func_75874_d()) continue;
            PathPoint currentTarget = this.field_75514_c.func_75877_a(this.field_75514_c.func_75873_e() + i);
            double dx = Math.abs((double)((float)currentTarget.field_75839_a + (float)((int)(this.field_75515_a.func_213311_cf() + 1.0f)) * 0.5f) - this.field_75515_a.func_226277_ct_());
            double dy = Math.abs((double)currentTarget.field_75837_b - this.field_75515_a.func_226278_cu_());
            double dz = Math.abs((double)((float)currentTarget.field_75838_c + (float)((int)(this.field_75515_a.func_213311_cf() + 1.0f)) * 0.5f) - this.field_75515_a.func_226281_cx_());
            boolean isWaypointInReach = dx < (double)this.field_188561_o && dy < (double)maxDistanceToWaypointY && dz < (double)this.field_188561_o;
            boolean isOnSameSideAsTarget = false;
            isOnSameSideAsTarget = this.func_212238_t() && (currentTarget.field_186287_m == PathNodeType.WATER || currentTarget.field_186287_m == PathNodeType.WATER_BORDER || currentTarget.field_186287_m == PathNodeType.LAVA) ? true : (currentTarget instanceof DirectionalPathPoint ? (targetSide = ((DirectionalPathPoint)currentTarget).getPathSide()) == null || this.climber.getGroundDirection().getLeft() == targetSide : true);
            if (!isOnSameSideAsTarget || !isWaypointInReach && (i != 0 || !this.field_75515_a.func_233660_b_(this.field_75514_c.func_237225_h_().field_186287_m) || !this.isNextTargetInLine(pos, sizeX, sizeY, sizeZ, 1 + i))) continue;
            this.field_75514_c.func_75872_c(this.field_75514_c.func_75873_e() + 1 + i);
            break;
        }
        if (this.findDirectPathPoints) {
            Direction.Axis verticalAxis = this.verticalFacing.func_176740_k();
            int firstDifferentHeightPoint = this.field_75514_c.func_75874_d();
            block0 : switch (verticalAxis) {
                case X: {
                    for (int i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                        if ((double)this.field_75514_c.func_75877_a((int)i).field_75839_a == Math.floor(pos.field_72450_a)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Y: {
                    for (int i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                        if ((double)this.field_75514_c.func_75877_a((int)i).field_75837_b == Math.floor(pos.field_72448_b)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
                case Z: {
                    for (int i = this.field_75514_c.func_75873_e(); i < this.field_75514_c.func_75874_d(); ++i) {
                        if ((double)this.field_75514_c.func_75877_a((int)i).field_75838_c == Math.floor(pos.field_72449_c)) continue;
                        firstDifferentHeightPoint = i;
                        break block0;
                    }
                    break;
                }
            }
            for (int i = firstDifferentHeightPoint - 1; i >= this.field_75514_c.func_75873_e(); --i) {
                if (!this.func_75493_a(pos, this.field_75514_c.func_75881_a((Entity)this.field_75515_a, i), sizeX, sizeY, sizeZ)) continue;
                this.field_75514_c.func_75872_c(i);
                break;
            }
        }
        this.func_179677_a(pos);
    }

    private boolean isNextTargetInLine(Vector3d pos, int sizeX, int sizeY, int sizeZ, int offset) {
        Vector3d currentDir;
        if (this.field_75514_c.func_75873_e() + offset >= this.field_75514_c.func_75874_d()) {
            return false;
        }
        Vector3d currentTarget = Vector3d.func_237492_c_((Vector3i)this.field_75514_c.func_242948_g());
        if (!pos.func_237488_a_((IPosition)currentTarget, 2.0)) {
            return false;
        }
        Vector3d nextTarget = Vector3d.func_237492_c_((Vector3i)this.field_75514_c.func_242947_d(this.field_75514_c.func_75873_e() + offset));
        Vector3d targetDir = nextTarget.func_178788_d(currentTarget);
        if (targetDir.func_72430_b(currentDir = pos.func_178788_d(currentTarget)) > 0.0) {
            boolean invertY;
            Direction.Axis az;
            Direction.Axis ay;
            Direction.Axis ax;
            switch (this.verticalFacing.func_176740_k()) {
                case X: {
                    ax = Direction.Axis.Z;
                    ay = Direction.Axis.X;
                    az = Direction.Axis.Y;
                    invertY = this.verticalFacing.func_82601_c() < 0;
                    break;
                }
                default: {
                    ax = Direction.Axis.X;
                    ay = Direction.Axis.Y;
                    az = Direction.Axis.Z;
                    invertY = this.verticalFacing.func_96559_d() < 0;
                    break;
                }
                case Z: {
                    ax = Direction.Axis.Y;
                    ay = Direction.Axis.Z;
                    az = Direction.Axis.X;
                    invertY = this.verticalFacing.func_82599_e() < 0;
                }
            }
            return this.isSafeToStandAt(MathHelper.func_76128_c((double)nextTarget.field_72450_a), MathHelper.func_76128_c((double)nextTarget.field_72448_b), MathHelper.func_76128_c((double)nextTarget.field_72449_c), sizeX, sizeY, sizeZ, currentTarget, 0.0, 0.0, -1.0, ax, ay, az, invertY);
        }
        return false;
    }

    protected boolean func_75493_a(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ) {
        switch (this.verticalFacing.func_176740_k()) {
            case X: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Z, Direction.Axis.X, Direction.Axis.Y, 0.0, this.verticalFacing.func_82601_c() < 0);
            }
            case Y: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.X, Direction.Axis.Y, Direction.Axis.Z, 0.0, this.verticalFacing.func_96559_d() < 0);
            }
            case Z: {
                return this.isDirectPathBetweenPoints(start, end, sizeX, sizeY, sizeZ, Direction.Axis.Y, Direction.Axis.Z, Direction.Axis.X, 0.0, this.verticalFacing.func_82599_e() < 0);
            }
        }
        return false;
    }

    protected static double swizzle(Vector3d vec, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return vec.field_72450_a;
            }
            case Y: {
                return vec.field_72448_b;
            }
            case Z: {
                return vec.field_72449_c;
            }
        }
        return 0.0;
    }

    protected static int swizzle(int x, int y, int z, Direction.Axis axis) {
        switch (axis) {
            case X: {
                return x;
            }
            case Y: {
                return y;
            }
            case Z: {
                return z;
            }
        }
        return 0;
    }

    protected static int unswizzle(int x, int y, int z, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, Direction.Axis axis) {
        Direction.Axis unswizzle = axis == ax ? Direction.Axis.X : (axis == ay ? Direction.Axis.Y : Direction.Axis.Z);
        return AdvancedClimberPathNavigator.swizzle(x, y, z, unswizzle);
    }

    protected boolean isDirectPathBetweenPoints(Vector3d start, Vector3d end, int sizeX, int sizeY, int sizeZ, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, double minDotProduct, boolean invertY) {
        int bx = MathHelper.func_76128_c((double)AdvancedClimberPathNavigator.swizzle(start, ax));
        int bz = MathHelper.func_76128_c((double)AdvancedClimberPathNavigator.swizzle(start, az));
        double dx = AdvancedClimberPathNavigator.swizzle(end, ax) - AdvancedClimberPathNavigator.swizzle(start, ax);
        double dz = AdvancedClimberPathNavigator.swizzle(end, az) - AdvancedClimberPathNavigator.swizzle(start, az);
        double dSq = dx * dx + dz * dz;
        int by = (int)AdvancedClimberPathNavigator.swizzle(start, ay);
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeY2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ay);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        if (dSq < 1.0E-8) {
            return false;
        }
        double d3 = 1.0 / Math.sqrt(dSq);
        if (!this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2 += 2, sizeY2, sizeZ2 += 2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx *= d3, dz *= d3, minDotProduct, ax, ay, az, invertY)) {
            return false;
        }
        sizeX2 -= 2;
        sizeZ2 -= 2;
        double stepX = 1.0 / Math.abs(dx);
        double stepZ = 1.0 / Math.abs(dz);
        double relX = (double)bx - AdvancedClimberPathNavigator.swizzle(start, ax);
        double relZ = (double)bz - AdvancedClimberPathNavigator.swizzle(start, az);
        if (dx >= 0.0) {
            relX += 1.0;
        }
        if (dz >= 0.0) {
            relZ += 1.0;
        }
        relX /= dx;
        relZ /= dz;
        int dirX = dx < 0.0 ? -1 : 1;
        int dirZ = dz < 0.0 ? -1 : 1;
        int ex = MathHelper.func_76128_c((double)AdvancedClimberPathNavigator.swizzle(end, ax));
        int ez = MathHelper.func_76128_c((double)AdvancedClimberPathNavigator.swizzle(end, az));
        int offsetX = ex - bx;
        int offsetZ = ez - bz;
        while (offsetX * dirX > 0 || offsetZ * dirZ > 0) {
            if (relX < relZ) {
                relX += stepX;
                offsetX = ex - (bx += dirX);
            } else {
                relZ += stepZ;
                offsetZ = ez - (bz += dirZ);
            }
            if (this.isSafeToStandAt(AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, by, bz, ax, ay, az, Direction.Axis.Z), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(sizeX2, sizeY2, sizeZ2, ax, ay, az, Direction.Axis.Z), start, dx, dz, minDotProduct, ax, ay, az, invertY)) continue;
            return false;
        }
        return true;
    }

    protected boolean isSafeToStandAt(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az, boolean invertY) {
        int sizeX2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, ax);
        int sizeZ2 = AdvancedClimberPathNavigator.swizzle(sizeX, sizeY, sizeZ, az);
        int bx = AdvancedClimberPathNavigator.swizzle(x, y, z, ax) - sizeX2 / 2;
        int bz = AdvancedClimberPathNavigator.swizzle(x, y, z, az) - sizeZ2 / 2;
        int by = AdvancedClimberPathNavigator.swizzle(x, y, z, ay);
        if (!this.isPositionClear(AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(bx, y, bz, ax, ay, az, Direction.Axis.Z), sizeX, sizeY, sizeZ, start, dx, dz, minDotProduct, ax, ay, az)) {
            return false;
        }
        for (int obx = bx; obx < bx + sizeX2; ++obx) {
            for (int obz = bz; obz < bz + sizeZ2; ++obz) {
                double offsetZ;
                double offsetX = (double)obx + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
                if (!(offsetX * dx + (offsetZ = (double)obz + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct)) continue;
                PathNodeType nodeTypeBelow = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by + (invertY ? 1 : -1), obz, ax, ay, az, Direction.Axis.Z), this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                if (nodeTypeBelow == PathNodeType.WATER) {
                    return false;
                }
                if (nodeTypeBelow == PathNodeType.LAVA) {
                    return false;
                }
                if (nodeTypeBelow == PathNodeType.OPEN) {
                    return false;
                }
                PathNodeType nodeType = this.field_179695_a.func_186319_a((IBlockReader)this.field_75513_b, AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.X), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Y), AdvancedClimberPathNavigator.unswizzle(obx, by, obz, ax, ay, az, Direction.Axis.Z), this.field_75515_a, sizeX, sizeY, sizeZ, true, true);
                float f = this.field_75515_a.func_184643_a(nodeType);
                if (f < 0.0f || f >= 8.0f) {
                    return false;
                }
                if (nodeType != PathNodeType.DAMAGE_FIRE && nodeType != PathNodeType.DANGER_FIRE && nodeType != PathNodeType.DAMAGE_OTHER) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPositionClear(int x, int y, int z, int sizeX, int sizeY, int sizeZ, Vector3d start, double dx, double dz, double minDotProduct, Direction.Axis ax, Direction.Axis ay, Direction.Axis az) {
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)new BlockPos(x, y, z), (BlockPos)new BlockPos(x + sizeX - 1, y + sizeY - 1, z + sizeZ - 1))) {
            BlockState state;
            double pffsetZ;
            double offsetX = (double)AdvancedClimberPathNavigator.swizzle(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ax) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, ax);
            if (!(offsetX * dx + (pffsetZ = (double)AdvancedClimberPathNavigator.swizzle(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), az) + 0.5 - AdvancedClimberPathNavigator.swizzle(start, az)) * dz >= minDotProduct) || (state = this.field_75513_b.func_180495_p(pos)).func_196957_g((IBlockReader)this.field_75513_b, pos, PathType.LAND)) continue;
            return false;
        }
        return true;
    }
}

