/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.controller.JumpController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.movement.ClimberJumpController;

public class ClimberMoveController<T extends MobEntity>
extends MovementController {
    protected final IClimberEntity climber;
    @Nullable
    protected BlockPos block;
    @Nullable
    protected Direction side;

    public ClimberMoveController(T entity) {
        super(entity);
        this.climber = (IClimberEntity)entity;
    }

    public void func_75642_a(double x, double y, double z, double speedIn) {
        this.setMoveTo(x, y, z, null, null, speedIn);
    }

    public void setMoveTo(double x, double y, double z, BlockPos block, Direction side, double speedIn) {
        super.func_75642_a(x, y, z, speedIn);
        this.block = block;
        this.side = side;
    }

    public void func_75641_c() {
        double speed = (double)this.climber.getMovementSpeed() * this.field_75645_e;
        if (this.field_188491_h == MovementController.Action.STRAFE) {
            this.field_188491_h = MovementController.Action.WAIT;
            float forward = this.field_188489_f;
            float strafe = this.field_188490_g;
            float moveSpeed = MathHelper.func_76129_c((float)(forward * forward + strafe * strafe));
            if (moveSpeed < 1.0f) {
                moveSpeed = 1.0f;
            }
            moveSpeed = (float)speed / moveSpeed;
            Orientation orientation = this.climber.getOrientation();
            Vector3d forwardVector = orientation.getGlobal(this.field_75648_a.field_70177_z, 0.0f);
            Vector3d strafeVector = orientation.getGlobal(this.field_75648_a.field_70177_z + 90.0f, 0.0f);
            if (!this.isWalkableAtOffset(forwardVector.field_72450_a * (double)(forward *= moveSpeed) + strafeVector.field_72450_a * (double)(strafe *= moveSpeed), forwardVector.field_72448_b * (double)forward + strafeVector.field_72448_b * (double)strafe, forwardVector.field_72449_c * (double)forward + strafeVector.field_72449_c * (double)strafe)) {
                this.field_188489_f = 1.0f;
                this.field_188490_g = 0.0f;
            }
            this.field_75648_a.func_70659_e((float)speed);
            this.field_75648_a.func_191989_p(this.field_188489_f);
            this.field_75648_a.func_184646_p(this.field_188490_g);
        } else if (this.field_188491_h == MovementController.Action.MOVE_TO) {
            double hdz;
            double hdy;
            double hdx;
            double hdsq;
            float reach;
            this.field_188491_h = MovementController.Action.WAIT;
            double dx = this.field_75646_b - this.field_75648_a.func_226277_ct_();
            double dy = this.field_75647_c - this.field_75648_a.func_226278_cu_();
            double dz = this.field_75644_d - this.field_75648_a.func_226281_cx_();
            if (this.side != null && this.block != null) {
                VoxelShape shape = this.field_75648_a.field_70170_p.func_180495_p(this.block).func_196952_d((IBlockReader)this.field_75648_a.field_70170_p, this.block);
                AxisAlignedBB aabb = this.field_75648_a.func_174813_aQ();
                double ox = 0.0;
                double oy = 0.0;
                double oz = 0.0;
                switch (this.side) {
                    case DOWN: {
                        if (!(aabb.field_72338_b >= (double)this.block.func_177956_o() + shape.func_197758_c(Direction.Axis.Y) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case UP: {
                        if (!(aabb.field_72337_e <= (double)this.block.func_177956_o() + shape.func_197762_b(Direction.Axis.Y) + 0.01)) break;
                        oy += 0.1;
                        break;
                    }
                    case WEST: {
                        if (!(aabb.field_72340_a >= (double)this.block.func_177958_n() + shape.func_197758_c(Direction.Axis.X) - 0.01)) break;
                        ox -= 0.1;
                        break;
                    }
                    case EAST: {
                        if (!(aabb.field_72336_d <= (double)this.block.func_177958_n() + shape.func_197762_b(Direction.Axis.X) + 0.01)) break;
                        ox += 0.1;
                        break;
                    }
                    case NORTH: {
                        if (!(aabb.field_72339_c >= (double)this.block.func_177952_p() + shape.func_197758_c(Direction.Axis.Z) - 0.01)) break;
                        oz -= 0.1;
                        break;
                    }
                    case SOUTH: {
                        if (!(aabb.field_72334_f <= (double)this.block.func_177952_p() + shape.func_197762_b(Direction.Axis.Z) + 0.01)) break;
                        oz += 0.1;
                    }
                }
                AxisAlignedBB blockAabb = new AxisAlignedBB(this.block.func_177972_a(this.side.func_176734_d()));
                if (aabb.func_72326_a(blockAabb)) {
                    double offset;
                    Direction.Axis offsetAxis = this.side.func_176740_k();
                    switch (offsetAxis) {
                        default: {
                            offset = (float)this.side.func_82601_c() * 0.5f;
                            break;
                        }
                        case Y: {
                            offset = (float)this.side.func_96559_d() * 0.5f;
                            break;
                        }
                        case Z: {
                            offset = (float)this.side.func_82599_e() * 0.5f;
                        }
                    }
                    double allowedOffset = shape.func_212430_a(offsetAxis, aabb.func_72317_d((double)(-this.block.func_177958_n()), (double)(-this.block.func_177956_o()), (double)(-this.block.func_177952_p())), offset);
                    switch (this.side) {
                        case DOWN: {
                            if (!(aabb.field_72338_b + allowedOffset < (double)this.block.func_177956_o() + shape.func_197758_c(Direction.Axis.Y) - 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case UP: {
                            if (!(aabb.field_72337_e + allowedOffset > (double)this.block.func_177956_o() + shape.func_197762_b(Direction.Axis.Y) + 0.01)) break;
                            oy = 0.0;
                            break;
                        }
                        case WEST: {
                            if (!(aabb.field_72340_a + allowedOffset < (double)this.block.func_177958_n() + shape.func_197758_c(Direction.Axis.X) - 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case EAST: {
                            if (!(aabb.field_72336_d + allowedOffset > (double)this.block.func_177958_n() + shape.func_197762_b(Direction.Axis.X) + 0.01)) break;
                            ox = 0.0;
                            break;
                        }
                        case NORTH: {
                            if (!(aabb.field_72339_c + allowedOffset < (double)this.block.func_177952_p() + shape.func_197758_c(Direction.Axis.Z) - 0.01)) break;
                            oz = 0.0;
                            break;
                        }
                        case SOUTH: {
                            if (!(aabb.field_72334_f + allowedOffset > (double)this.block.func_177952_p() + shape.func_197762_b(Direction.Axis.Z) + 0.01)) break;
                            oz = 0.0;
                        }
                    }
                }
                dx += ox;
                dy += oy;
                dz += oz;
            }
            Direction mainOffsetDir = Direction.func_210769_a((double)dx, (double)dy, (double)dz);
            switch (mainOffsetDir) {
                case DOWN: {
                    reach = 0.0f;
                    break;
                }
                case UP: {
                    reach = this.field_75648_a.func_213302_cg();
                    break;
                }
                default: {
                    reach = this.field_75648_a.func_213311_cf() * 0.5f;
                }
            }
            double verticalOffset = Math.abs((double)mainOffsetDir.func_82601_c() * dx) + Math.abs((double)mainOffsetDir.func_96559_d() * dy) + Math.abs((double)mainOffsetDir.func_82599_e() * dz);
            Direction groundDir = (Direction)this.climber.getGroundDirection().getLeft();
            Vector3d jumpDir = null;
            if (this.side != null && verticalOffset > (double)(reach - 0.05f) && groundDir != this.side && groundDir.func_176740_k() != this.side.func_176740_k() && (hdsq = (hdx = (double)(1 - Math.abs(mainOffsetDir.func_82601_c())) * dx) * hdx + (hdy = (double)(1 - Math.abs(mainOffsetDir.func_96559_d())) * dy) * hdy + (hdz = (double)(1 - Math.abs(mainOffsetDir.func_82599_e())) * dz) * hdz) < (double)0.707f) {
                dx -= (double)((float)this.side.func_82601_c() * 0.2f);
                dy -= (double)((float)this.side.func_96559_d() * 0.2f);
                dz -= (double)((float)this.side.func_82599_e() * 0.2f);
                if (hdsq < (double)0.1f) {
                    jumpDir = new Vector3d((double)mainOffsetDir.func_82601_c(), (double)mainOffsetDir.func_96559_d(), (double)mainOffsetDir.func_82599_e());
                }
            }
            Orientation orientation = this.climber.getOrientation();
            Vector3d up = orientation.getGlobal(this.field_75648_a.field_70177_z, -90.0f);
            Vector3d offset = new Vector3d(dx, dy, dz);
            Vector3d targetDir = offset.func_178788_d(up.func_186678_a(offset.func_72430_b(up)));
            double targetDist = targetDir.func_72433_c();
            targetDir = targetDir.func_72432_b();
            if (targetDist < 1.0E-4) {
                this.field_75648_a.func_191989_p(0.0f);
            } else {
                float rx = (float)orientation.localZ.func_72430_b(targetDir);
                float ry = (float)orientation.localX.func_72430_b(targetDir);
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, 270.0f - (float)Math.toDegrees(MathHelper.func_181159_b((double)rx, (double)ry)), 90.0f);
                if (jumpDir == null && this.side != null && targetDist < 0.1 && groundDir == this.side.func_176734_d()) {
                    jumpDir = new Vector3d((double)this.side.func_82601_c(), (double)this.side.func_96559_d(), (double)this.side.func_82599_e());
                }
                if (jumpDir != null) {
                    this.field_75648_a.func_70659_e((float)speed * 0.5f);
                    JumpController jumpController = this.field_75648_a.func_70683_ar();
                    if (jumpController instanceof ClimberJumpController) {
                        ((ClimberJumpController)jumpController).setJumping(jumpDir);
                    }
                } else {
                    this.field_75648_a.func_70659_e((float)speed);
                }
            }
        } else if (this.field_188491_h == MovementController.Action.JUMPING) {
            this.field_75648_a.func_70659_e((float)speed);
            if (this.field_75648_a.func_233570_aj_()) {
                this.field_188491_h = MovementController.Action.WAIT;
            }
        } else {
            this.field_75648_a.func_191989_p(0.0f);
        }
    }

    private boolean isWalkableAtOffset(double x, double y, double z) {
        NodeProcessor processor;
        PathNavigator navigator = this.field_75648_a.func_70661_as();
        return navigator == null || (processor = navigator.func_189566_q()) == null || processor.func_186330_a((IBlockReader)this.field_75648_a.field_70170_p, MathHelper.func_76128_c((double)(this.field_75648_a.func_226277_ct_() + x)), MathHelper.func_76128_c((double)(this.field_75648_a.func_226278_cu_() + (double)(this.field_75648_a.func_213302_cg() * 0.5f) + y)), MathHelper.func_76128_c((double)(this.field_75648_a.func_226281_cx_() + z))) == PathNodeType.WALKABLE;
    }
}

