/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.Direction;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;

public class DirectionalPathPoint
extends PathPoint {
    protected static final long ALL_DIRECTIONS = AdvancedWalkNodeProcessor.packDirection(Direction.UP, AdvancedWalkNodeProcessor.packDirection(Direction.DOWN, AdvancedWalkNodeProcessor.packDirection(Direction.NORTH, AdvancedWalkNodeProcessor.packDirection(Direction.EAST, AdvancedWalkNodeProcessor.packDirection(Direction.SOUTH, AdvancedWalkNodeProcessor.packDirection(Direction.WEST, 0L))))));
    protected static final Direction[] DIRECTIONS = Direction.values();
    private final Direction[] pathableSides;
    private final Direction pathSide;
    private final boolean isDrop;

    public DirectionalPathPoint(int x, int y, int z, long packed, boolean isDrop) {
        super(x, y, z);
        EnumSet<Direction> directionsSet = EnumSet.noneOf(Direction.class);
        for (int i = 0; i < DIRECTIONS.length; ++i) {
            Direction dir = DIRECTIONS[i];
            if (!AdvancedWalkNodeProcessor.unpackDirection(dir, packed)) continue;
            directionsSet.add(dir);
        }
        this.pathableSides = directionsSet.toArray(new Direction[0]);
        this.pathSide = null;
        this.isDrop = isDrop;
    }

    public DirectionalPathPoint(PathPoint point, long packed, boolean isDrop) {
        this(point.field_75839_a, point.field_75837_b, point.field_75838_c, packed, isDrop);
        this.field_75835_d = point.field_75835_d;
        this.field_75836_e = point.field_75836_e;
        this.field_75833_f = point.field_75833_f;
        this.field_75834_g = point.field_75834_g;
        this.field_75841_h = point.field_75841_h;
        this.field_75842_i = point.field_75842_i;
        this.field_222861_j = point.field_222861_j;
        this.field_186286_l = point.field_186286_l;
        this.field_186287_m = point.field_186287_m;
    }

    public DirectionalPathPoint(PathPoint point) {
        this(point, ALL_DIRECTIONS, false);
    }

    private DirectionalPathPoint(int x, int y, int z, Direction[] pathableSides, Direction pathSide, boolean isDrop) {
        super(x, y, z);
        this.pathableSides = new Direction[pathableSides.length];
        System.arraycopy(pathableSides, 0, this.pathableSides, 0, pathableSides.length);
        this.pathSide = pathSide;
        this.isDrop = isDrop;
    }

    public DirectionalPathPoint(PathPoint point, Direction pathSide) {
        super(point.field_75839_a, point.field_75837_b, point.field_75838_c);
        this.field_75835_d = point.field_75835_d;
        this.field_75836_e = point.field_75836_e;
        this.field_75833_f = point.field_75833_f;
        this.field_75834_g = point.field_75834_g;
        this.field_75841_h = point.field_75841_h;
        this.field_75842_i = point.field_75842_i;
        this.field_222861_j = point.field_222861_j;
        this.field_186286_l = point.field_186286_l;
        this.field_186287_m = point.field_186287_m;
        if (point instanceof DirectionalPathPoint) {
            DirectionalPathPoint other = (DirectionalPathPoint)point;
            this.pathableSides = new Direction[other.pathableSides.length];
            System.arraycopy(other.pathableSides, 0, this.pathableSides, 0, other.pathableSides.length);
            this.isDrop = other.isDrop;
        } else {
            this.pathableSides = Direction.values();
            this.isDrop = false;
        }
        this.pathSide = pathSide;
    }

    public DirectionalPathPoint assignPathSide(Direction pathDirection) {
        return new DirectionalPathPoint(this, pathDirection);
    }

    public PathPoint func_186283_a(int x, int y, int z) {
        DirectionalPathPoint pathPoint = new DirectionalPathPoint(x, y, z, this.pathableSides, this.pathSide, this.isDrop);
        pathPoint.field_75835_d = this.field_75835_d;
        pathPoint.field_75836_e = this.field_75836_e;
        pathPoint.field_75833_f = this.field_75833_f;
        pathPoint.field_75834_g = this.field_75834_g;
        pathPoint.field_75841_h = this.field_75841_h;
        pathPoint.field_75842_i = this.field_75842_i;
        pathPoint.field_222861_j = this.field_222861_j;
        pathPoint.field_186286_l = this.field_186286_l;
        pathPoint.field_186287_m = this.field_186287_m;
        return pathPoint;
    }

    public Direction[] getPathableSides() {
        return this.pathableSides;
    }

    @Nullable
    public Direction getPathSide() {
        return this.pathSide;
    }

    public boolean isDrop() {
        return this.isDrop;
    }
}

