/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.mixins;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.entity.ai.goal.TargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tcb.spiderstpo.common.Config;
import tcb.spiderstpo.common.ModTags;
import tcb.spiderstpo.common.entity.goal.BetterLeapAtTargetGoal;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.IMobEntityRegisterGoalsHook;

@Mixin(value={SpiderEntity.class}, priority=1001)
public abstract class BetterSpiderEntityMixin
extends MonsterEntity
implements IClimberEntity,
IMobEntityRegisterGoalsHook {
    private static final UUID FOLLOW_RANGE_INCREASE_ID = UUID.fromString("9e815957-3a8e-4b65-afbc-eba39d2a06b4");
    private static final AttributeModifier FOLLOW_RANGE_INCREASE = new AttributeModifier(FOLLOW_RANGE_INCREASE_ID, "Spiders 2.0 follow range increase", 8.0, AttributeModifier.Operation.ADDITION);
    private boolean pathFinderDebugPreview;

    private BetterSpiderEntityMixin(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.func_110148_a(Attributes.field_233819_b_).func_233769_c_(FOLLOW_RANGE_INCREASE);
    }

    @Inject(method={"registerData()V"}, at={@At(value="HEAD")})
    private void onRegisterData(CallbackInfo ci) {
        this.pathFinderDebugPreview = (Boolean)Config.PATH_FINDER_DEBUG_PREVIEW.get();
    }

    @Redirect(method={"registerGoals()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ai/goal/GoalSelector;addGoal(ILnet/minecraft/entity/ai/goal/Goal;)V"))
    private void onAddGoal(GoalSelector selector, int priority, Goal task) {
        if (task instanceof LeapAtTargetGoal) {
            selector.func_75776_a(3, new BetterLeapAtTargetGoal<BetterSpiderEntityMixin>(this, 0.4f));
        } else if (task instanceof TargetGoal) {
            selector.func_75776_a(2, (Goal)((TargetGoal)task).func_190882_b(200));
        } else {
            selector.func_75776_a(priority, task);
        }
    }

    @Override
    public boolean shouldTrackPathingTargets() {
        return this.pathFinderDebugPreview;
    }

    @Override
    public boolean canClimbOnBlock(BlockState state, BlockPos pos) {
        return !state.func_177230_c().func_203417_a(ModTags.NON_CLIMBABLE);
    }

    @Override
    public float getBlockSlipperiness(BlockPos pos) {
        BlockState offsetState = this.field_70170_p.func_180495_p(pos);
        float slipperiness = offsetState.func_177230_c().getSlipperiness(offsetState, (IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.91f;
        if (offsetState.func_177230_c().func_203417_a(ModTags.NON_CLIMBABLE)) {
            slipperiness = 1.0f - (1.0f - slipperiness) * 0.25f;
        }
        return slipperiness;
    }

    @Override
    public float getPathingMalus(IBlockReader cache, MobEntity entity, PathNodeType nodeType, BlockPos pos, Vector3i direction, Predicate<Direction> sides) {
        if (direction.func_177956_o() != 0) {
            boolean hasClimbableNeigbor = false;
            BlockPos.Mutable offsetPos = new BlockPos.Mutable();
            for (Direction offset : Direction.values()) {
                if (!sides.test(offset)) continue;
                offsetPos.func_181079_c(pos.func_177958_n() + offset.func_82601_c(), pos.func_177956_o() + offset.func_96559_d(), pos.func_177952_p() + offset.func_82599_e());
                BlockState state = cache.func_180495_p((BlockPos)offsetPos);
                if (!this.canClimbOnBlock(state, (BlockPos)offsetPos)) continue;
                hasClimbableNeigbor = true;
            }
            if (!hasClimbableNeigbor) {
                return -1.0f;
            }
        }
        return entity.func_184643_a(nodeType);
    }
}

