/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.upsizer;

import cpw.mods.modlauncher.api.INameMappingService;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jwaresoftware.mcmods.upsizer.UpsConfig;
import org.jwaresoftware.mcmods.upsizer.UpsPatch;
import org.jwaresoftware.mcmods.upsizer.UpsTags;

@Mod(value="upsizer")
@Mod.EventBusSubscriber(modid="upsizer", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Upsizer {
    private static final Logger _modLog = LogManager.getLogger((String)"UpS");
    public static Upsizer instance;
    private static ConcurrentHashMap<ITag<Item>, Integer> CHECK;
    private static ConcurrentHashMap<ResourceLocation, Integer> CHECK_BYNAME;
    private static ConcurrentHashMap<Item, Integer> DONE;
    private Field _MAXSIZE_FIELD = null;
    private UpsConfig _config;
    private boolean _allowDownsizing = false;

    public Upsizer() {
        instance = this;
        this.readField();
        this._config = UpsConfig.getInstance();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, UpsConfig.SPEC, UpsConfig.getFile().getPath());
        if (this._MAXSIZE_FIELD != null) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::updateVanillaItems);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::updateModdedItems);
            MinecraftForge.EVENT_BUS.addListener(this::onServerStarting);
            MinecraftForge.EVENT_BUS.addListener(this::onItemTagsLoaded);
        }
    }

    private void onServerStarting(FMLServerStartingEvent event) {
        boolean bl = UpsPatch.ENABLED = this._config.fixBowlFood() && this._config.maxStackStews() > 1;
        if (UpsPatch.ENABLED) {
            MinecraftForge.EVENT_BUS.register((Object)new UpsPatch());
        }
    }

    private void onItemTagsLoaded(TagsUpdatedEvent.VanillaTagTypes event) {
        if (CHECK == null) {
            return;
        }
        ConcurrentHashMap<ITag<Item>, Integer> m = CHECK;
        CHECK = null;
        for (ResourceLocation resourceLocation : CHECK_BYNAME.keySet()) {
            ITag<Item> tag = Upsizer.getTag(resourceLocation);
            if (tag == null) continue;
            m.putIfAbsent(tag, CHECK_BYNAME.get(resourceLocation));
        }
        CHECK_BYNAME.clear();
        CHECK_BYNAME = null;
        for (Map.Entry entry : m.entrySet()) {
            int n = (Integer)entry.getValue();
            this.adjust((ITag<Item>)((ITag)entry.getKey()), n);
        }
        m.clear();
        m = null;
        DONE.clear();
        DONE = null;
    }

    private void updateVanillaItems(FMLCommonSetupEvent event) {
        this._allowDownsizing = this._config.isDownsizable();
        this.adjust(Items.field_151110_aK, this._config.maxStackRawEggs(), (ITag<Item>)Tags.Items.EGGS);
        this.adjust(Items.field_151133_ar, this._config.maxStackBuckets());
        this.adjust(Items.field_151079_bi, this._config.maxStackEnderPearls());
        this.adjust(Items.field_151126_ay, this._config.maxStackSnowballs());
        this.adjust(Items.field_226638_pX_, this._config.maxStackHoneyBottles());
        this.adjust(Items.field_151131_as, this._config.maxStackWaterBuckets());
        this.adjust(Items.field_151117_aB, this._config.maxStackMilkBuckets());
        this.adjust(Items.field_151129_at, this._config.maxStackLavaBuckets());
        this.adjust(Items.field_151143_au, this._config.maxStackEmptyMinecarts());
        this.adjust(Items.field_151141_av, this._config.maxStackSaddles(), (ITag<Item>)UpsTags.SADDLES);
        this.adjust(Items.field_185159_cQ, this._config.maxStackShields());
        this.adjust(Blocks.field_150414_aQ, this._config.maxStackCakes());
        this.adjust(Items.field_151134_bR, this._config.maxStackEnchantBooks());
        this.adjust(Items.field_151099_bA, this._config.maxStackWritableBooks());
        int n = this._config.maxStackSigns();
        if (n > 1) {
            this.adjust(Items.field_222071_kr, n);
            this.adjust(Items.field_222072_ks, n);
            this.adjust(Items.field_222073_kt, n);
            this.adjust(Items.field_222074_ku, n);
            this.adjust(Items.field_222075_kv, n);
            this.adjust(Items.field_222076_kw, n);
            this.adjust(Items.field_234761_lI_, n);
            this.adjust(Items.field_234762_lJ_, n);
            CHECK.put((ITag<Item>)ItemTags.field_219773_J, n);
        }
        if ((n = this._config.maxStackStews()) > 1) {
            this.adjust(Items.field_179560_bq, n);
            this.adjust(Items.field_151009_A, n);
            this.adjust(Items.field_185165_cW, n);
            this.adjust(Items.field_222115_pz, n);
        }
        if ((n = this._config.maxStackTools()) > 1) {
            this.adjust(Items.field_151033_d, n);
            this.adjust(Items.field_151097_aZ, n);
            this.adjust(Items.field_151112_aM, n);
            this.adjust(Items.field_151146_bM, n);
            this.adjust(Items.field_234774_pk_, n);
            this.adjust(Items.field_151053_p, n);
            this.adjust(Items.field_151039_o, n);
            this.adjust(Items.field_151038_n, n);
            this.adjust(Items.field_151017_I, n);
            this.adjust(Items.field_151049_t, n);
            this.adjust(Items.field_151050_s, n);
            this.adjust(Items.field_151051_r, n);
            this.adjust(Items.field_151018_J, n);
            this.adjust(Items.field_151036_c, n);
            this.adjust(Items.field_151035_b, n);
            this.adjust(Items.field_151037_a, n);
            this.adjust(Items.field_151019_K, n);
            this.adjust(Items.field_151006_E, n);
            this.adjust(Items.field_151005_D, n);
            this.adjust(Items.field_151011_C, n);
            this.adjust(Items.field_151013_M, n);
            this.adjust(Items.field_151056_x, n);
            this.adjust(Items.field_151046_w, n);
            this.adjust(Items.field_151047_v, n);
            this.adjust(Items.field_151012_L, n);
            this.adjust(Items.field_234757_kL_, n);
            this.adjust(Items.field_234756_kK_, n);
            this.adjust(Items.field_234755_kJ_, n);
            this.adjust(Items.field_234758_kU_, n);
            CHECK.put((ITag<Item>)Tags.Items.SHEARS, n);
        }
        if ((n = this._config.maxStackWeapons()) > 1) {
            this.adjust(Items.field_151031_f, n);
            this.adjust(Items.field_222114_py, n);
            this.adjust(Items.field_151041_m, n);
            this.adjust(Items.field_151052_q, n);
            this.adjust(Items.field_151024_Q, n);
            this.adjust(Items.field_151027_R, n);
            this.adjust(Items.field_151026_S, n);
            this.adjust(Items.field_151021_T, n);
            this.adjust(Items.field_151040_l, n);
            this.adjust(Items.field_151028_Y, n);
            this.adjust(Items.field_151030_Z, n);
            this.adjust(Items.field_151165_aa, n);
            this.adjust(Items.field_151167_ab, n);
            this.adjust(Items.field_151010_B, n);
            this.adjust(Items.field_151169_ag, n);
            this.adjust(Items.field_151171_ah, n);
            this.adjust(Items.field_151149_ai, n);
            this.adjust(Items.field_151151_aj, n);
            this.adjust(Items.field_151048_u, n);
            this.adjust(Items.field_151161_ac, n);
            this.adjust(Items.field_151163_ad, n);
            this.adjust(Items.field_151173_ae, n);
            this.adjust(Items.field_151175_af, n);
            this.adjust(Items.field_151020_U, n);
            this.adjust(Items.field_151023_V, n);
            this.adjust(Items.field_151022_W, n);
            this.adjust(Items.field_151029_X, n);
            this.adjust(Items.field_203184_eO, n);
            this.adjust(Items.field_203179_ao, n);
            this.adjust(Items.field_234754_kI_, n);
            this.adjust(Items.field_234763_ls_, n);
            this.adjust(Items.field_234764_lt_, n);
            this.adjust(Items.field_234765_lu_, n);
            this.adjust(Items.field_234766_lv_, n);
        }
        if ((n = this._config.maxStackHorseArmor()) > 1) {
            this.adjust(Items.field_222110_op, n);
            this.adjust(Items.field_151138_bX, n);
            this.adjust(Items.field_151136_bY, n);
            this.adjust(Items.field_151125_bZ, n);
        }
        if ((n = this._config.maxStackBoats()) > 1) {
            this.adjust(Items.field_151124_az, n);
            this.adjust(Items.field_185154_aL, n);
            this.adjust(Items.field_185151_aI, n);
            this.adjust(Items.field_185153_aK, n);
            this.adjust(Items.field_185152_aJ, n);
            this.adjust(Items.field_185150_aH, n);
            CHECK.put((ITag<Item>)ItemTags.field_202902_o, n);
        }
        if ((n = this._config.maxStackRecords()) > 1) {
            this.adjust(Items.field_196156_dS, n);
            this.adjust(Items.field_196158_dT, n);
            this.adjust(Items.field_196160_dU, n);
            this.adjust(Items.field_196162_dV, n);
            this.adjust(Items.field_196164_dW, n);
            this.adjust(Items.field_196166_dX, n);
            this.adjust(Items.field_196168_dY, n);
            this.adjust(Items.field_196170_dZ, n);
            this.adjust(Items.field_196187_ea, n);
            this.adjust(Items.field_196188_eb, n);
            this.adjust(Items.field_196189_ec, n);
            this.adjust(Items.field_196190_ed, n);
            this.adjust(Items.field_234775_qK_, n);
            CHECK.put((ITag<Item>)ItemTags.field_219774_K, n);
        }
        n = this._config.maxStackBanners();
        if (this._allowDownsizing || n > 1) {
            this.adjust(Items.field_196191_eg, n);
            this.adjust(Items.field_196192_eh, n);
            this.adjust(Items.field_196193_ei, n);
            this.adjust(Items.field_196194_ej, n);
            this.adjust(Items.field_196195_ek, n);
            this.adjust(Items.field_196196_el, n);
            this.adjust(Items.field_196197_em, n);
            this.adjust(Items.field_196198_en, n);
            this.adjust(Items.field_196199_eo, n);
            this.adjust(Items.field_196200_ep, n);
            this.adjust(Items.field_196201_eq, n);
            this.adjust(Items.field_196202_er, n);
            this.adjust(Items.field_196203_es, n);
            this.adjust(Items.field_196204_et, n);
            this.adjust(Items.field_196205_eu, n);
            this.adjust(Items.field_196206_ev, n);
            CHECK.put((ITag<Item>)ItemTags.field_202901_n, n);
        }
        if ((n = this._config.maxStackBannerPatterns()) > 1) {
            this.adjust(Items.field_222095_pB, n);
            this.adjust(Items.field_222096_pC, n);
            this.adjust(Items.field_222097_pD, n);
            this.adjust(Items.field_222098_pE, n);
            this.adjust(Items.field_222099_pF, n);
            this.adjust(Items.field_234776_qX_, n);
            CHECK.put((ITag<Item>)UpsTags.BANNER_PATTERNS, n);
        }
        if ((n = this._config.maxStackBeds()) > 1) {
            this.adjust(Items.field_196140_bu, n);
            this.adjust(Items.field_196142_bv, n);
            this.adjust(Items.field_196144_bw, n);
            this.adjust(Items.field_196146_bx, n);
            this.adjust(Items.field_196148_by, n);
            this.adjust(Items.field_196150_bz, n);
            this.adjust(Items.field_196090_bA, n);
            this.adjust(Items.field_196091_bB, n);
            this.adjust(Items.field_196092_bC, n);
            this.adjust(Items.field_196093_bD, n);
            this.adjust(Items.field_196094_bE, n);
            this.adjust(Items.field_196095_bF, n);
            this.adjust(Items.field_196096_bG, n);
            this.adjust(Items.field_196097_bH, n);
            this.adjust(Items.field_196098_bI, n);
            this.adjust(Items.field_196099_bJ, n);
            CHECK.put((ITag<Item>)ItemTags.field_219771_F, n);
        }
        if ((n = this._config.maxStackPotions()) > 1) {
            this.adjust(Items.field_151068_bn, n);
            this.adjust(Items.field_185155_bH, n);
            this.adjust(Items.field_185156_bI, n);
        }
        if ((n = this._config.maxStackEmptyShulkerBoxes()) > 1) {
            this.adjust(Items.field_221972_gr, n);
            this.adjust(Items.field_221974_gs, n);
            this.adjust(Items.field_221976_gt, n);
            this.adjust(Items.field_221978_gu, n);
            this.adjust(Items.field_221980_gv, n);
            this.adjust(Items.field_221982_gw, n);
            this.adjust(Items.field_221984_gx, n);
            this.adjust(Items.field_221986_gy, n);
            this.adjust(Items.field_221988_gz, n);
            this.adjust(Items.field_221885_gA, n);
            this.adjust(Items.field_221887_gB, n);
            this.adjust(Items.field_221889_gC, n);
            this.adjust(Items.field_221891_gD, n);
            this.adjust(Items.field_221893_gE, n);
            this.adjust(Items.field_221895_gF, n);
            this.adjust(Items.field_221897_gG, n);
            CHECK.put((ITag<Item>)UpsTags.SHULKER_BOXES, n);
        }
    }

    private void updateModdedItems(InterModProcessEvent event) {
        Map<String, Integer> custom = this._config.getCustomStackDefs();
        for (Map.Entry<String, Integer> e : custom.entrySet()) {
            this.adjust(e.getKey(), (int)e.getValue());
        }
    }

    private void adjust(Item item, int preferredSize, @Nullable ITag<Item> check) {
        if (preferredSize > 0 && (this._allowDownsizing || item.getItemStackLimit(new ItemStack((IItemProvider)item)) < preferredSize)) {
            this.resize(item, preferredSize);
            if (CHECK != null && check != null) {
                CHECK.putIfAbsent(check, preferredSize);
            }
        }
    }

    private void adjust(ITag<Item> tag, int preferredSize) {
        try {
            for (Item item : tag.func_230236_b_()) {
                this.adjust(item, preferredSize, null);
            }
        }
        catch (IllegalStateException badTagX) {
            _modLog.catching(Level.WARN, (Throwable)badTagX);
        }
    }

    private void adjust(Item item, int preferredSize) {
        this.adjust(item, preferredSize, null);
    }

    private void adjust(Block blok, int preferredSize) {
        this.adjust(blok.func_199767_j(), preferredSize);
    }

    @Nullable
    public static final ITag<Item> getTag(ResourceLocation tag) {
        return tag == null ? null : TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tag);
    }

    private void adjust(String id, int preferredSize) {
        boolean tagged = id.startsWith("#");
        if (tagged && (id = id.substring(1)).isEmpty()) {
            return;
        }
        ResourceLocation r = ResourceLocation.func_208304_a((String)id);
        if (r != null) {
            if (tagged || !ForgeRegistries.ITEMS.containsKey(r)) {
                if (tagged) {
                    CHECK_BYNAME.put(r, preferredSize);
                } else {
                    _modLog.warn("Unable to find item '{}' in registry; ignoring", (Object)r);
                }
                return;
            }
            Item item = (Item)ForgeRegistries.ITEMS.getValue(r);
            if (item != null && item != Items.field_190931_a) {
                this.adjust(item, preferredSize);
            }
        } else {
            _modLog.warn("Unable to parse as item or tag id '{}'; ignoring", (Object)id);
        }
    }

    private void readField() {
        try {
            Field field = Item.class.getDeclaredField(ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.FIELD, (String)"field_77777_bU"));
            field.setAccessible(true);
            this._MAXSIZE_FIELD = field;
            _modLog.debug("Item.maxSize set accessible");
        }
        catch (Throwable igX) {
            _modLog.catching(Level.WARN, igX);
        }
    }

    private void resize(Item item, int preferredSize) {
        if (DONE != null && DONE.getOrDefault(item, -999) != preferredSize) {
            try {
                int old = this._MAXSIZE_FIELD.getInt(item);
                this._MAXSIZE_FIELD.setInt(item, preferredSize);
                DONE.put(item, preferredSize);
                if (this._config.isDebugMode() && _modLog.isDebugEnabled()) {
                    _modLog.debug(" {} -> {} , {}", (Object)item.getClass().getSimpleName(), (Object)old, (Object)this._MAXSIZE_FIELD.getInt(item));
                }
            }
            catch (Throwable igX) {
                _modLog.catching(Level.DEBUG, igX);
            }
        }
    }

    static {
        CHECK = new ConcurrentHashMap(11);
        CHECK_BYNAME = new ConcurrentHashMap(11);
        DONE = new ConcurrentHashMap(123);
    }
}

